"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderThreatMatchRows = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../../../../common/constants");
var _event_id = require("../../../../../../common/components/event_details/event_id");
var _row_renderer = require("../row_renderer");
var _threat_match_row = require("./threat_match_row");
var _translations = require("../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpacedContainer = _styledComponents.default.div`
  margin: ${({
  theme
}) => theme.eui.euiSizeS} 0;
`;
const renderThreatMatchRows = ({
  data,
  isDraggable,
  scopeId
}) => {
  return /*#__PURE__*/_react.default.createElement(ThreatMatchRowWrapper, {
    data: data,
    isDraggable: isDraggable,
    scopeId: scopeId
  });
};
exports.renderThreatMatchRows = renderThreatMatchRows;
const MAX_INDICATOR_VISIBLE = 2;
const ThreatMatchRowWrapper = ({
  data,
  isDraggable,
  scopeId
}) => {
  const indicators = (0, _lodash.get)(data, _constants.ENRICHMENT_DESTINATION_PATH);
  const eventId = (0, _lodash.get)(data, _event_id.ID_FIELD_NAME);
  const getThreatMatchRows = (0, _react.useCallback)((mode = 'max') => {
    const allIndicators = mode === 'max' ? indicators.slice(0, MAX_INDICATOR_VISIBLE) : indicators;
    return /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
      "data-test-subj": "threat-match-row-renderer"
    }, /*#__PURE__*/_react.default.createElement(SpacedContainer, null, allIndicators.map((indicator, index) => {
      const contextId = `threat-match-row-${scopeId}-${eventId}-${index}`;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: contextId
      }, /*#__PURE__*/_react.default.createElement(_threat_match_row.ThreatMatchRow, {
        contextId: contextId,
        data: indicator,
        eventId: eventId,
        isDraggable: isDraggable
      }), index < indicators.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "s"
      }));
    })));
  }, [indicators, eventId, isDraggable, scopeId]);
  const renderModalChildren = (0, _react.useCallback)(() => getThreatMatchRows('all'), [getThreatMatchRows]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getThreatMatchRows()), indicators.length > MAX_INDICATOR_VISIBLE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ThreatMatchRowModal, {
    title: (0, _translations.SHOW_ALL_INDICATOR_MATCHES)(indicators.length),
    renderChildren: renderModalChildren
  })));
};
const ThreatMatchRowModal = ({
  title,
  renderChildren
}) => {
  const [isModalVisible, setShowModal] = (0, _react.useState)(false);
  const closeModal = () => setShowModal(false);
  const showModal = () => setShowModal(true);
  let modal;
  if (isModalVisible) {
    modal = /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeModal
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      "data-test-subj": "threat-match-row-modal"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _translations.ALL_INDICATOR_MATCHES_MODAL_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, renderChildren()), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: closeModal,
      fill: true
    }, _translations.ALL_INDICATOR_MATCHES_MODAL_CLOSE)));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "threat-match-row-show-all",
    iconType: "popout",
    color: "primary",
    onClick: showModal
  }, title), modal);
};