"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nilOrUnSet = exports.PrimarySecondaryUserInfo = exports.PrimarySecondary = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nilOrUnSet = value => value == null || value.toLowerCase() === 'unset';
exports.nilOrUnSet = nilOrUnSet;
const PrimarySecondary = exports.PrimarySecondary = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  primary,
  secondary,
  isDraggable
}) => {
  if (nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return null;
  } else if (!nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.primary",
      isDraggable: isDraggable,
      value: primary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else if (nilOrUnSet(primary) && !nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      isDraggable: isDraggable,
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else if (primary === secondary) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      isDraggable: isDraggable,
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.primary",
      isDraggable: isDraggable,
      value: primary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, i18n.AS), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      isDraggable: isDraggable,
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    })));
  }
});
PrimarySecondary.displayName = 'PrimarySecondary';
const PrimarySecondaryUserInfo = exports.PrimarySecondaryUserInfo = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  userName,
  primary,
  secondary,
  isDraggable
}) => {
  if (nilOrUnSet(userName) && nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return null;
  } else if (!nilOrUnSet(userName) && !nilOrUnSet(primary) && !nilOrUnSet(secondary) && userName === primary && userName === secondary) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "user.name",
      isDraggable: isDraggable,
      value: userName,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else if (!nilOrUnSet(userName) && nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "user.name",
      isDraggable: isDraggable,
      value: userName,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(PrimarySecondary, {
      contextId: contextId,
      eventId: eventId,
      isDraggable: isDraggable,
      primary: primary,
      secondary: secondary
    });
  }
});
PrimarySecondaryUserInfo.displayName = 'PrimarySecondaryUserInfo';