"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuditdGenericFileLine = exports.AuditdGenericFileDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _netflow = require("../netflow");
var _helpers = require("../helpers");
var _process_draggable = require("../process_draggable");
var _args = require("../args");
var _session_user_host_working_dir = require("./session_user_host_working_dir");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuditdGenericFileLine = exports.AuditdGenericFileLine = /*#__PURE__*/_react.default.memo(({
  id,
  contextId,
  hostName,
  userName,
  result,
  primary,
  secondary,
  filePath,
  processName,
  processPid,
  processExecutable,
  processTitle,
  workingDirectory,
  args,
  session,
  text,
  fileIcon,
  isDraggable
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_session_user_host_working_dir.SessionUserHostWorkingDir, {
  eventId: id,
  contextId: contextId,
  hostName: hostName,
  userName: userName,
  primary: primary,
  secondary: secondary,
  workingDirectory: workingDirectory,
  session: session,
  isDraggable: isDraggable
}), (filePath != null || processExecutable != null) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, text), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: id,
  field: "file.path",
  isDraggable: isDraggable,
  value: filePath,
  iconType: fileIcon
})), processExecutable != null && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, i18n.USING), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggable, {
  contextId: contextId,
  endgamePid: undefined,
  endgameProcessName: undefined,
  eventId: id,
  isDraggable: isDraggable,
  processPid: processPid,
  processName: processName,
  processExecutable: processExecutable
})), /*#__PURE__*/_react.default.createElement(_args.Args, {
  eventId: id,
  args: args,
  contextId: contextId,
  isDraggable: isDraggable,
  processTitle: processTitle
}), result != null && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, i18n.WITH_RESULT), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: id,
  field: "auditd.result",
  isDraggable: isDraggable,
  queryValue: result,
  value: result
}))));
AuditdGenericFileLine.displayName = 'AuditdGenericFileLine';
const AuditdGenericFileDetails = exports.AuditdGenericFileDetails = /*#__PURE__*/_react.default.memo(({
  data,
  contextId,
  text,
  fileIcon = 'document',
  timelineId,
  isDraggable
}) => {
  const id = data._id;
  const session = (0, _fp.get)('auditd.session[0]', data);
  const hostName = (0, _fp.get)('host.name[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  const result = (0, _fp.get)('auditd.result[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const processName = (0, _fp.get)('process.name[0]', data);
  const processExecutable = (0, _fp.get)('process.executable[0]', data);
  const processTitle = (0, _fp.get)('process.title[0]', data);
  const workingDirectory = (0, _fp.get)('process.working_directory[0]', data);
  const filePath = (0, _fp.get)('file.path[0]', data);
  const primary = (0, _fp.get)('auditd.summary.actor.primary[0]', data);
  const secondary = (0, _fp.get)('auditd.summary.actor.secondary[0]', data);
  const args = (0, _fp.get)('process.args', data);
  if (data.process != null) {
    return /*#__PURE__*/_react.default.createElement(_helpers.Details, null, /*#__PURE__*/_react.default.createElement(AuditdGenericFileLine, {
      id: id,
      contextId: contextId,
      text: text,
      hostName: hostName,
      userName: userName,
      filePath: filePath,
      processName: processName,
      processPid: processPid,
      processExecutable: processExecutable,
      processTitle: processTitle,
      workingDirectory: workingDirectory,
      args: args,
      session: session,
      primary: primary,
      secondary: secondary,
      fileIcon: fileIcon,
      result: result,
      isDraggable: isDraggable
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
      data: data,
      isDraggable: isDraggable,
      timelineId: timelineId
    }));
  } else {
    return null;
  }
});
AuditdGenericFileDetails.displayName = 'AuditdGenericFileDetails';