"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgsComponent = exports.Args = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ArgsComponent = ({
  args,
  contextId,
  eventId,
  processTitle,
  isDraggable
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(args) && (0, _helpers.isNillEmptyOrNotFinite)(processTitle)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, args != null && args.map((arg, i) => /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    key: `${contextId}-args-${i}-${arg}`,
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: `${contextId}-args-${i}-${arg}`,
    eventId: eventId,
    field: "process.args",
    isDraggable: isDraggable,
    value: arg,
    fieldType: "keyword",
    isAggregatable: true
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(processTitle) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "process.title",
    isDraggable: isDraggable,
    value: processTitle,
    fieldType: "keyword",
    isAggregatable: true
  })));
};
exports.ArgsComponent = ArgsComponent;
ArgsComponent.displayName = 'ArgsComponent';
const Args = exports.Args = /*#__PURE__*/_react.default.memo(ArgsComponent);
Args.displayName = 'Args';