"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_FIELD_TYPE = exports.AlertField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _alert_field_badge = require("./alert_field_badge");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIELD_TYPE = exports.DEFAULT_FIELD_TYPE = 'keyword';
const AlertFieldComponent = ({
  contextId,
  'data-test-subj': dataTestSubj = 'alertField',
  eventId,
  field,
  fieldType = DEFAULT_FIELD_TYPE,
  isAggregatable = true,
  isDraggable,
  prefix,
  suffix,
  scopeId,
  values
}) => values != null ? /*#__PURE__*/_react.default.createElement(_helpers.AlertFieldFlexGroup, {
  alignItems: "center",
  "data-test-subj": dataTestSubj,
  $scopeId: scopeId,
  gutterSize: "none"
}, prefix != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "prefix",
  grow: false
}, prefix), values.map((x, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: `${x}-${i}`,
  grow: false
}, /*#__PURE__*/_react.default.createElement(_alert_field_badge.AlertFieldBadge, {
  contextId: `${contextId}-alert-field`,
  eventId: eventId,
  field: field,
  fieldType: fieldType,
  isAggregatable: isAggregatable,
  isDraggable: isDraggable,
  showSeparator: i < values.length - 1,
  scopeId: scopeId,
  value: x
}))), suffix != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "suffix",
  grow: false
}, suffix)) : null;
AlertFieldComponent.displayName = 'AlertFieldComponent';
const AlertField = exports.AlertField = /*#__PURE__*/_react.default.memo(AlertFieldComponent);