"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulBody = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/timelines-plugin/public");
var _header_actions = require("../../../../common/components/header_actions");
var _constants = require("./constants");
var _timeline = require("../../../../../common/api/timeline");
var _store = require("../../../store");
var _helpers = require("./column_headers/helpers");
var _helpers2 = require("./helpers");
var _plain_row_renderer = require("./renderers/plain_row_renderer");
var _styles = require("../styles");
var _column_headers = require("./column_headers");
var _events = require("./events");
var _use_license = require("../../../../common/hooks/use_license");
var _selectors = require("../../../store/selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The Body component is used everywhere timeline is used within the security application. It is the highest level component
 * that is shared across all implementations of the timeline.
 */
const StatefulBody = exports.StatefulBody = /*#__PURE__*/_react.default.memo(({
  activePage,
  browserFields,
  data,
  id,
  isEventViewer = false,
  onRuleChange,
  refetch,
  renderCellValue,
  rowRenderers,
  sort,
  tabType,
  totalPages,
  leadingControlColumns = [],
  trailingControlColumns = []
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const containerRef = (0, _react.useRef)(null);
  const {
    columns,
    eventIdToNoteIds,
    excludedRowRendererIds,
    isSelectAllChecked,
    loadingEventIds,
    pinnedEventIds,
    selectedEventIds,
    show,
    queryFields,
    selectAll
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, id));
  const columnHeaders = (0, _react.useMemo)(() => (0, _helpers.getColumnHeaders)(columns, browserFields), [browserFields, columns]);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = isEnterprisePlus ? 6 : 5;
  const onRowSelected = (0, _react.useCallback)(({
    eventIds,
    isSelected
  }) => {
    dispatch(_store.timelineActions.setSelected({
      id,
      eventIds: (0, _helpers2.getEventIdToDataMapping)(data, eventIds, queryFields),
      isSelected,
      isSelectAllChecked: isSelected && Object.keys(selectedEventIds).length + 1 === data.length
    }));
  }, [data, dispatch, id, queryFields, selectedEventIds]);
  const onSelectAll = (0, _react.useCallback)(({
    isSelected
  }) => isSelected ? dispatch(_store.timelineActions.setSelected({
    id,
    eventIds: (0, _helpers2.getEventIdToDataMapping)(data, data.map(event => event._id), queryFields),
    isSelected,
    isSelectAllChecked: isSelected
  })) : dispatch(_store.timelineActions.clearSelected({
    id
  })), [data, dispatch, id, queryFields]);

  // Sync to selectAll so parent components can select all events
  (0, _react.useEffect)(() => {
    if (selectAll && !isSelectAllChecked) {
      onSelectAll({
        isSelected: true
      });
    }
  }, [isSelectAllChecked, onSelectAll, selectAll]);
  const enabledRowRenderers = (0, _react.useMemo)(() => {
    if (excludedRowRendererIds && excludedRowRendererIds.length === _timeline.RowRendererCount) return [_plain_row_renderer.plainRowRenderer];
    if (!excludedRowRendererIds) return rowRenderers;
    return rowRenderers.filter(rowRenderer => !excludedRowRendererIds.includes(rowRenderer.id));
  }, [excludedRowRendererIds, rowRenderers]);
  const actionsColumnWidth = (0, _react.useMemo)(() => (0, _header_actions.getActionsColumnWidth)(ACTION_BUTTON_COUNT), [ACTION_BUTTON_COUNT]);
  const columnWidths = (0, _react.useMemo)(() => columnHeaders.reduce((totalWidth, header) => {
    var _header$initialWidth;
    return totalWidth + ((_header$initialWidth = header.initialWidth) !== null && _header$initialWidth !== void 0 ? _header$initialWidth : _constants.DEFAULT_COLUMN_MIN_WIDTH);
  }, 0), [columnHeaders]);
  const leadingActionColumnsWidth = (0, _react.useMemo)(() => {
    return leadingControlColumns ? leadingControlColumns.reduce((totalWidth, header) => header.width ? totalWidth + header.width : totalWidth + actionsColumnWidth, 0) : 0;
  }, [actionsColumnWidth, leadingControlColumns]);
  const trailingActionColumnsWidth = (0, _react.useMemo)(() => {
    return trailingControlColumns ? trailingControlColumns.reduce((totalWidth, header) => header.width ? totalWidth + header.width : totalWidth + actionsColumnWidth, 0) : 0;
  }, [actionsColumnWidth, trailingControlColumns]);
  const totalWidth = (0, _react.useMemo)(() => {
    return columnWidths + leadingActionColumnsWidth + trailingActionColumnsWidth;
  }, [columnWidths, leadingActionColumnsWidth, trailingActionColumnsWidth]);
  const [lastFocusedAriaColindex] = (0, _react.useState)(_public.FIRST_ARIA_INDEX);
  const columnCount = (0, _react.useMemo)(() => {
    return columnHeaders.length + trailingControlColumns.length + leadingControlColumns.length;
  }, [columnHeaders, trailingControlColumns, leadingControlColumns]);
  const onKeyDown = (0, _react.useCallback)(e => {
    (0, _public.onKeyDownFocusHandler)({
      colindexAttribute: _public.ARIA_COLINDEX_ATTRIBUTE,
      containerElement: containerRef.current,
      event: e,
      maxAriaColindex: columnHeaders.length + 1,
      maxAriaRowindex: data.length + 1,
      onColumnFocused: _fp.noop,
      rowindexAttribute: _public.ARIA_ROWINDEX_ATTRIBUTE
    });
  }, [columnHeaders.length, containerRef, data.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_styles.TimelineBody, {
    "data-test-subj": "timeline-body",
    ref: containerRef
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTable, {
    $activePage: activePage,
    $columnCount: columnCount,
    "data-test-subj": `${tabType}-events-table`,
    columnWidths: totalWidth,
    onKeyDown: onKeyDown,
    $rowCount: data.length,
    $totalPages: totalPages
  }, /*#__PURE__*/_react.default.createElement(_column_headers.ColumnHeaders, {
    actionsColumnWidth: actionsColumnWidth,
    browserFields: browserFields,
    columnHeaders: columnHeaders,
    isEventViewer: isEventViewer,
    isSelectAllChecked: isSelectAllChecked,
    onSelectAll: onSelectAll,
    show: show,
    showEventsSelect: false,
    showSelectAllCheckbox: false,
    sort: sort,
    tabType: tabType,
    timelineId: id,
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns
  }), /*#__PURE__*/_react.default.createElement(_events.Events, {
    containerRef: containerRef,
    actionsColumnWidth: actionsColumnWidth,
    columnHeaders: columnHeaders,
    data: data,
    eventIdToNoteIds: eventIdToNoteIds,
    id: id,
    isEventViewer: isEventViewer,
    lastFocusedAriaColindex: lastFocusedAriaColindex,
    loadingEventIds: loadingEventIds,
    onRowSelected: onRowSelected,
    pinnedEventIds: pinnedEventIds,
    refetch: refetch,
    renderCellValue: renderCellValue,
    rowRenderers: enabledRowRenderers,
    onRuleChange: onRuleChange,
    selectedEventIds: selectedEventIds,
    showCheckboxes: false,
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns,
    tabType: tabType
  }))), /*#__PURE__*/_react.default.createElement(_styles.TimelineBodyGlobalStyle, null));
});
StatefulBody.displayName = 'StatefulBody';