"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Events = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _styles = require("../../styles");
var _stateful_event = require("./stateful_event");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** This offset begins at two, because the header row counts as "row 1", and aria-rowindex starts at "1" */
const ARIA_ROW_INDEX_OFFSET = 2;
const EventsComponent = ({
  actionsColumnWidth,
  columnHeaders,
  containerRef,
  data,
  eventIdToNoteIds,
  id,
  isEventViewer = false,
  lastFocusedAriaColindex,
  loadingEventIds,
  onRowSelected,
  pinnedEventIds,
  refetch,
  onRuleChange,
  renderCellValue,
  rowRenderers,
  selectedEventIds,
  showCheckboxes,
  tabType,
  leadingControlColumns,
  trailingControlColumns
}) => /*#__PURE__*/_react.default.createElement(_styles.EventsTbody, {
  "data-test-subj": "events"
}, data.map((event, i) => {
  var _event$ecs$eql, _event$ecs$eql2;
  return /*#__PURE__*/_react.default.createElement(_stateful_event.StatefulEvent, {
    actionsColumnWidth: actionsColumnWidth,
    ariaRowindex: i + ARIA_ROW_INDEX_OFFSET,
    columnHeaders: columnHeaders,
    containerRef: containerRef,
    event: event,
    eventIdToNoteIds: eventIdToNoteIds,
    isEventPinned: (0, _helpers.eventIsPinned)({
      eventId: event._id,
      pinnedEventIds
    }),
    isEventViewer: isEventViewer,
    key: `${id}_${tabType}_${event._id}_${event._index}_${!(0, _lodash.isEmpty)((_event$ecs$eql = event.ecs.eql) === null || _event$ecs$eql === void 0 ? void 0 : _event$ecs$eql.sequenceNumber) ? (_event$ecs$eql2 = event.ecs.eql) === null || _event$ecs$eql2 === void 0 ? void 0 : _event$ecs$eql2.sequenceNumber : ''}`,
    lastFocusedAriaColindex: lastFocusedAriaColindex,
    loadingEventIds: loadingEventIds,
    onRowSelected: onRowSelected,
    renderCellValue: renderCellValue,
    refetch: refetch,
    rowRenderers: rowRenderers,
    onRuleChange: onRuleChange,
    selectedEventIds: selectedEventIds,
    showCheckboxes: showCheckboxes,
    tabType: tabType,
    timelineId: id,
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns
  });
}));
const Events = exports.Events = /*#__PURE__*/_react.default.memo(EventsComponent);