"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetMappedNonEcsValue = exports.shouldForwardKeyDownEvent = exports.onKeyDown = exports.getMappedNonEcsValue = exports.DataDrivenColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _helpers = require("../../helpers");
var _styles = require("../../styles");
var _stateful_cell = require("./stateful_cell");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPACE = ' ';
const shouldForwardKeyDownEvent = key => {
  switch (key) {
    case SPACE: // fall through
    case 'Enter':
      return true;
    default:
      return false;
  }
};
exports.shouldForwardKeyDownEvent = shouldForwardKeyDownEvent;
const onKeyDown = keyboardEvent => {
  var _targetElement$classN;
  const {
    altKey,
    ctrlKey,
    key,
    metaKey,
    shiftKey,
    target,
    type
  } = keyboardEvent;
  const targetElement = target;

  // we *only* forward the event to the (child) draggable keyboard wrapper
  // if the keyboard event originated from the container (TD) element
  if (shouldForwardKeyDownEvent(key) && (_targetElement$classN = targetElement.className) !== null && _targetElement$classN !== void 0 && _targetElement$classN.includes(_styles.EVENTS_TD_CLASS_NAME)) {
    const draggableKeyboardWrapper = targetElement.querySelector(`.${_securitysolutionTGrid.DRAGGABLE_KEYBOARD_WRAPPER_CLASS_NAME}`);
    const newEvent = new KeyboardEvent(type, {
      altKey,
      bubbles: true,
      cancelable: true,
      ctrlKey,
      key,
      metaKey,
      shiftKey
    });
    if (key === ' ') {
      // prevent the default behavior of scrolling the table when space is pressed
      keyboardEvent.preventDefault();
    }
    draggableKeyboardWrapper === null || draggableKeyboardWrapper === void 0 ? void 0 : draggableKeyboardWrapper.dispatchEvent(newEvent);
  }
};
exports.onKeyDown = onKeyDown;
const TgridActionTdCell = ({
  action: Action,
  width,
  actionsColumnWidth,
  ariaRowindex,
  columnId,
  columnValues,
  data,
  ecsData,
  eventIdToNoteIds,
  index,
  isEventPinned,
  isEventViewer,
  eventId,
  loadingEventIds,
  notesCount,
  onEventDetailsPanelOpened,
  onRowSelected,
  refetch,
  rowIndex,
  hasRowRenderers,
  onRuleChange,
  selectedEventIds,
  showCheckboxes,
  showNotes,
  tabType,
  timelineId,
  toggleShowNotes,
  setEventsLoading,
  setEventsDeleted
}) => {
  const displayWidth = width ? width : actionsColumnWidth;
  return /*#__PURE__*/_react.default.createElement(_styles.EventsTdGroupActions, {
    width: displayWidth,
    "data-test-subj": "event-actions-container",
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTd, {
    $ariaColumnIndex: index + _helpers.ARIA_COLUMN_INDEX_OFFSET,
    key: tabType != null ? `${eventId}_${tabType}` : `${eventId}`,
    onKeyDown: onKeyDown,
    role: "button",
    tabIndex: 0,
    width: width
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    "data-test-subj": "cell-container"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "screenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.YOU_ARE_IN_A_TABLE_CELL({
    row: ariaRowindex,
    column: index + 2
  }))), Action && /*#__PURE__*/_react.default.createElement(Action, {
    ariaRowindex: ariaRowindex,
    width: width,
    checked: Object.keys(selectedEventIds).includes(eventId),
    columnId: columnId,
    columnValues: columnValues,
    eventId: eventId,
    data: data,
    ecsData: ecsData,
    eventIdToNoteIds: eventIdToNoteIds,
    index: index,
    isEventPinned: isEventPinned,
    isEventViewer: isEventViewer,
    loadingEventIds: loadingEventIds,
    onEventDetailsPanelOpened: onEventDetailsPanelOpened,
    onRowSelected: onRowSelected,
    refetch: refetch,
    rowIndex: rowIndex,
    onRuleChange: onRuleChange,
    showCheckboxes: showCheckboxes,
    showNotes: showNotes,
    timelineId: timelineId,
    toggleShowNotes: toggleShowNotes,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: setEventsDeleted
  }))), hasRowRenderers ? /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "hasRowRendererScreenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.EVENT_HAS_AN_EVENT_RENDERER(ariaRowindex))) : null, notesCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "hasNotesScreenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.EVENT_HAS_NOTES({
    row: ariaRowindex,
    notesCount
  }))) : null));
};
const TgridTdCell = ({
  _id,
  ariaRowindex,
  index,
  header,
  data,
  ecsData,
  hasRowRenderers,
  notesCount,
  renderCellValue,
  tabType,
  timelineId
}) => {
  var _header$linkField;
  const ariaColIndex = index + _helpers.ARIA_COLUMN_INDEX_OFFSET;
  return /*#__PURE__*/_react.default.createElement(_styles.EventsTd, {
    $ariaColumnIndex: ariaColIndex,
    key: tabType != null ? `${header.id}_${tabType}` : `${header.id}`,
    onKeyDown: onKeyDown,
    role: "button",
    tabIndex: 0,
    width: header.initialWidth
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    "data-test-subj": "cell-container"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "screenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.YOU_ARE_IN_A_TABLE_CELL({
    row: ariaRowindex,
    column: ariaColIndex
  }))), /*#__PURE__*/_react.default.createElement(_stateful_cell.StatefulCell, {
    rowIndex: ariaRowindex - 1,
    colIndex: ariaColIndex - 1,
    data: data,
    header: header,
    eventId: _id,
    linkValues: (0, _fp.getOr)([], (_header$linkField = header.linkField) !== null && _header$linkField !== void 0 ? _header$linkField : '', ecsData),
    renderCellValue: renderCellValue,
    tabType: tabType,
    timelineId: timelineId
  }))), hasRowRenderers ? /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "hasRowRendererScreenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.EVENT_HAS_AN_EVENT_RENDERER(ariaRowindex))) : null, notesCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "hasNotesScreenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.EVENT_HAS_NOTES({
    row: ariaRowindex,
    notesCount
  }))) : null);
};
const DataDrivenColumns = exports.DataDrivenColumns = /*#__PURE__*/_react.default.memo(({
  ariaRowindex,
  actionsColumnWidth,
  columnHeaders,
  columnValues,
  data,
  ecsData,
  eventIdToNoteIds,
  isEventPinned,
  isEventViewer,
  id: _id,
  loadingEventIds,
  notesCount,
  onEventDetailsPanelOpened,
  onRowSelected,
  refetch,
  hasRowRenderers,
  onRuleChange,
  renderCellValue,
  selectedEventIds,
  showCheckboxes,
  showNotes,
  tabType,
  timelineId,
  toggleShowNotes,
  trailingControlColumns,
  leadingControlColumns,
  setEventsLoading,
  setEventsDeleted
}) => {
  const trailingActionCells = (0, _react.useMemo)(() => trailingControlColumns ? trailingControlColumns.map(column => column.rowCellRender) : [], [trailingControlColumns]);
  const leadingAndDataColumnCount = (0, _react.useMemo)(() => leadingControlColumns.length + columnHeaders.length, [leadingControlColumns, columnHeaders]);
  const TrailingActions = (0, _react.useMemo)(() => trailingActionCells.map((Action, index) => {
    return Action && /*#__PURE__*/_react.default.createElement(TgridActionTdCell, {
      action: Action,
      width: trailingControlColumns[index].width,
      actionsColumnWidth: actionsColumnWidth,
      ariaRowindex: ariaRowindex,
      checked: Object.keys(selectedEventIds).includes(_id),
      columnId: trailingControlColumns[index].id || '',
      columnValues: columnValues,
      onRowSelected: onRowSelected,
      "data-test-subj": "actions",
      eventId: _id,
      data: data,
      key: index,
      index: leadingAndDataColumnCount + index,
      rowIndex: ariaRowindex,
      ecsData: ecsData,
      loadingEventIds: loadingEventIds,
      onEventDetailsPanelOpened: onEventDetailsPanelOpened,
      showCheckboxes: showCheckboxes,
      eventIdToNoteIds: eventIdToNoteIds,
      isEventPinned: isEventPinned,
      isEventViewer: isEventViewer,
      notesCount: notesCount,
      refetch: refetch,
      hasRowRenderers: hasRowRenderers,
      onRuleChange: onRuleChange,
      selectedEventIds: selectedEventIds,
      showNotes: showNotes,
      tabType: tabType,
      timelineId: timelineId,
      toggleShowNotes: toggleShowNotes,
      setEventsLoading: setEventsLoading,
      setEventsDeleted: setEventsDeleted
    });
  }), [trailingControlColumns, _id, data, ecsData, onRowSelected, isEventPinned, isEventViewer, actionsColumnWidth, ariaRowindex, columnValues, eventIdToNoteIds, hasRowRenderers, leadingAndDataColumnCount, loadingEventIds, notesCount, onEventDetailsPanelOpened, onRuleChange, refetch, selectedEventIds, showCheckboxes, showNotes, tabType, timelineId, toggleShowNotes, trailingActionCells, setEventsLoading, setEventsDeleted]);
  const ColumnHeaders = (0, _react.useMemo)(() => columnHeaders.map((header, index) => /*#__PURE__*/_react.default.createElement(TgridTdCell, {
    _id: _id,
    index: index,
    header: header,
    key: tabType != null ? `${header.id}_${tabType}` : `${header.id}`,
    ariaRowindex: ariaRowindex,
    data: data,
    ecsData: ecsData,
    hasRowRenderers: hasRowRenderers,
    notesCount: notesCount,
    renderCellValue: renderCellValue,
    tabType: tabType,
    timelineId: timelineId
  })), [_id, ariaRowindex, columnHeaders, data, ecsData, hasRowRenderers, notesCount, renderCellValue, tabType, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_styles.EventsTdGroupData, {
    "data-test-subj": "data-driven-columns"
  }, ColumnHeaders, TrailingActions);
});
DataDrivenColumns.displayName = 'DataDrivenColumns';
const getMappedNonEcsValue = ({
  data,
  fieldName
}) => {
  /*
   While data _should_ always be defined
   There is the potential for race conditions where a component using this function
   is still visible in the UI, while the data has since been removed.
   To cover all scenarios where this happens we'll check for the presence of data here
  */
  if (!data || data.length === 0) return undefined;
  const item = data.find(d => d.field === fieldName);
  if (item != null && item.value != null) {
    return item.value;
  }
  return undefined;
};
exports.getMappedNonEcsValue = getMappedNonEcsValue;
const useGetMappedNonEcsValue = ({
  data,
  fieldName
}) => {
  return (0, _react.useMemo)(() => getMappedNonEcsValue({
    data,
    fieldName
  }), [data, fieldName]);
};
exports.useGetMappedNonEcsValue = useGetMappedNonEcsValue;