"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderComponent = exports.Header = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _esQuery = require("@kbn/es-query");
var _use_selector = require("../../../../../../common/hooks/use_selector");
var _store = require("../../../../../store");
var _actions = require("../actions");
var _filter = require("../filter");
var _helpers = require("./helpers");
var _header_content = require("./header_content");
var _selectors = require("./selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderComponent = ({
  header,
  onFilterChange = _fp.noop,
  sort,
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getIsEqlOn = (0, _react.useMemo)(() => (0, _selectors.isEqlOnSelector)(), []);
  const isEqlOn = (0, _use_selector.useShallowEqualSelector)(state => getIsEqlOn(state, timelineId));
  const onColumnSort = (0, _react.useCallback)(() => {
    var _header$type, _header$esTypes;
    const columnId = header.id;
    const columnType = (_header$type = header.type) !== null && _header$type !== void 0 ? _header$type : '';
    const esTypes = (_header$esTypes = header.esTypes) !== null && _header$esTypes !== void 0 ? _header$esTypes : [];
    const sortDirection = (0, _helpers.getNewSortDirectionOnClick)({
      clickedHeader: header,
      currentSort: sort
    });
    const headerIndex = sort.findIndex(col => col.columnId === columnId);
    let newSort = [];
    if (headerIndex === -1) {
      newSort = [...sort, {
        columnId,
        columnType,
        esTypes,
        sortDirection
      }];
    } else {
      newSort = [...sort.slice(0, headerIndex), {
        columnId,
        columnType,
        esTypes,
        sortDirection
      }, ...sort.slice(headerIndex + 1)];
    }
    dispatch(_store.timelineActions.updateSort({
      id: timelineId,
      sort: newSort
    }));
  }, [dispatch, header, sort, timelineId]);
  const onColumnRemoved = (0, _react.useCallback)(columnId => dispatch(_store.timelineActions.removeColumn({
    id: timelineId,
    columnId
  })), [dispatch, timelineId]);
  const getManageTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    isLoading
  } = (0, _use_selector.useDeepEqualSelector)(state => getManageTimeline(state, timelineId) || {
    isLoading: false
  });
  const showSortingCapability = !isEqlOn && !(0, _esQuery.isDataViewFieldSubtypeNested)(header);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_content.HeaderContent, {
    header: header,
    isLoading: isLoading,
    isResizing: false,
    onClick: onColumnSort,
    showSortingCapability: showSortingCapability,
    sort: sort
  }, /*#__PURE__*/_react.default.createElement(_actions.Actions, {
    header: header,
    isLoading: isLoading,
    onColumnRemoved: onColumnRemoved,
    sort: sort
  })), /*#__PURE__*/_react.default.createElement(_filter.Filter, {
    header: header,
    onFilterChange: onFilterChange
  }));
};
exports.HeaderComponent = HeaderComponent;
const Header = exports.Header = /*#__PURE__*/_react.default.memo(HeaderComponent);