"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Filter = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../constants");
var _text_filter = require("../text_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Renders a header's filter, based on the `columnHeaderType` */
const Filter = exports.Filter = /*#__PURE__*/_react.default.memo(({
  header,
  onFilterChange = _fp.noop
}) => {
  var _header$initialWidth;
  switch (header.columnHeaderType) {
    case 'text-filter':
      return /*#__PURE__*/_react.default.createElement(_text_filter.TextFilter, {
        columnId: header.id,
        minWidth: (_header$initialWidth = header.initialWidth) !== null && _header$initialWidth !== void 0 ? _header$initialWidth : _constants.DEFAULT_COLUMN_MIN_WIDTH,
        onFilterChange: onFilterChange,
        placeholder: header.placeholder
      });
    case 'not-filtered': // fall through
    default:
      return null;
  }
});
Filter.displayName = 'Filter';