"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventsSelectOptions = exports.DropdownDisplay = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _pin = require("../../../pin");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InputDisplay = _styledComponents.default.div`
  width: 5px;
`;
InputDisplay.displayName = 'InputDisplay';
const PinIconContainer = _styledComponents.default.div`
  margin-right: 5px;
`;
PinIconContainer.displayName = 'PinIconContainer';
const PinActionItem = _styledComponents.default.div`
  display: flex;
  flex-direction: row;
`;
PinActionItem.displayName = 'PinActionItem';
const DropdownDisplay = exports.DropdownDisplay = /*#__PURE__*/_react.default.memo(({
  text
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "subdued"
}, text));
DropdownDisplay.displayName = 'DropdownDisplay';
const getEventsSelectOptions = () => [{
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_ALL
  }),
  value: 'select-all'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_NONE
  }),
  value: 'select-none'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_PINNED
  }),
  value: 'select-pinned'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.SELECT_UNPINNED
  }),
  value: 'select-unpinned'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(PinActionItem, null, /*#__PURE__*/_react.default.createElement(PinIconContainer, null, /*#__PURE__*/_react.default.createElement(_pin.Pin, {
    allowUnpinning: true,
    isAlert: false,
    pinned: true
  })), /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.PIN_SELECTED
  })),
  value: 'pin-selected'
}, {
  inputDisplay: /*#__PURE__*/_react.default.createElement(InputDisplay, null),
  disabled: true,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(PinActionItem, null, /*#__PURE__*/_react.default.createElement(PinIconContainer, null, /*#__PURE__*/_react.default.createElement(_pin.Pin, {
    allowUnpinning: true,
    isAlert: false,
    pinned: false
  })), /*#__PURE__*/_react.default.createElement(DropdownDisplay, {
    text: i18n.UNPIN_SELECTED
  })),
  value: 'unpin-selected'
}];
exports.getEventsSelectOptions = getEventsSelectOptions;