"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseButton = exports.Actions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../../../styles");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Given a `header`, returns the `SortDirection` applicable to it */

const CloseButton = exports.CloseButton = /*#__PURE__*/_react.default.memo(({
  columnId,
  onColumnRemoved
}) => {
  const handleClick = (0, _react.useCallback)(event => {
    // To avoid a re-sorting when you delete a column
    event.preventDefault();
    event.stopPropagation();
    onColumnRemoved(columnId);
  }, [columnId, onColumnRemoved]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.REMOVE_COLUMN,
    color: "text",
    "data-test-subj": "remove-column",
    iconType: "cross",
    onClick: handleClick
  });
});
CloseButton.displayName = 'CloseButton';
const Actions = exports.Actions = /*#__PURE__*/_react.default.memo(({
  header,
  onColumnRemoved,
  sort,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, sort.some(i => i.columnId === header.id) && isLoading ? /*#__PURE__*/_react.default.createElement(_styles.EventsHeadingExtra, {
    className: "siemEventsHeading__extra--loading"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsLoading, {
    "data-test-subj": "timeline-loading-spinner"
  })) : /*#__PURE__*/_react.default.createElement(_styles.EventsHeadingExtra, {
    className: "siemEventsHeading__extra--close"
  }, /*#__PURE__*/_react.default.createElement(CloseButton, {
    columnId: header.id,
    onColumnRemoved: onColumnRemoved
  })));
});
Actions.displayName = 'Actions';