"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QUERY_ID = exports.ExpandableUserDetailsTitle = exports.ExpandableUserDetailsPageLink = exports.ExpandableUserDetails = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _constants = require("../../../../common/store/inputs/constants");
var _links = require("../../../../common/components/links");
var _user_overview = require("../../../../overview/components/user_overview");
var _observed_details = require("../../../../explore/users/containers/users/observed_details");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _actions = require("../../../../common/store/inputs/actions");
var _get_criteria_from_users_type = require("../../../../common/components/ml/criteria/get_criteria_from_users_type");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _model = require("../../../../explore/users/store/model");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_ID = exports.QUERY_ID = 'usersDetailsQuery';
const StyledTitle = _styledComponents.default.h4`
  word-break: break-all;
  word-wrap: break-word;
  white-space: pre-wrap;
`;
const ExpandableUserDetailsTitle = ({
  userName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(StyledTitle, null, _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.userDetails.title', {
  defaultMessage: 'User details'
}), `: ${userName}`));
exports.ExpandableUserDetailsTitle = ExpandableUserDetailsTitle;
const ExpandableUserDetailsPageLink = ({
  userName
}) => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
  userName: userName,
  isButton: true
}, _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.networkDetails.userDetails', {
  defaultMessage: 'View details page'
}));
exports.ExpandableUserDetailsPageLink = ExpandableUserDetailsPageLink;
const ExpandableUserDetails = ({
  contextID,
  scopeId,
  userName,
  isDraggable
}) => {
  const {
    to,
    from,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [loading, {
    userDetails
  }] = (0, _observed_details.useObservedUserDetails)({
    endDate: to,
    startDate: from,
    userName,
    indexNames: selectedPatterns,
    skip: isInitializing
  });
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _get_criteria_from_users_type.getCriteriaFromUsersType)(_model.UsersType.details, userName),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(_user_overview.UserOverview, {
    userName: userName,
    isInDetailsSidePanel: true,
    data: userDetails,
    loading: loading,
    contextID: contextID,
    sourcererScopeId: (0, _helpers.getSourcererScopeId)(scopeId),
    isDraggable: isDraggable,
    id: QUERY_ID,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById
  }));
};
exports.ExpandableUserDetails = ExpandableUserDetails;