"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableNetworkDetailsTitle = exports.ExpandableNetworkDetailsPageLink = exports.ExpandableNetworkDetails = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../../common/store/inputs/constants");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _links = require("../../../../common/components/links");
var _details = require("../../../../explore/network/components/details");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _network_to_criteria = require("../../../../common/components/ml/criteria/network_to_criteria");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _kibana = require("../../../../common/lib/kibana");
var _kuery = require("../../../../common/lib/kuery");
var _store = require("../../../../common/store");
var _actions = require("../../../../common/store/inputs/actions");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _details2 = require("../../../../explore/network/containers/details");
var _store2 = require("../../../../explore/network/store");
var _use_anomalies_table_data = require("../../../../common/components/ml/anomaly/use_anomalies_table_data");
var _use_installed_security_jobs = require("../../../../common/components/ml/hooks/use_installed_security_jobs");
var _empty_prompt = require("../../../../common/components/empty_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledTitle = _styledComponents.default.h4`
  word-break: break-all;
  word-wrap: break-word;
  white-space: pre-wrap;
`;
const ExpandableNetworkDetailsTitle = ({
  ip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(StyledTitle, null, _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.networkDetails.title', {
  defaultMessage: 'Network details'
}), `: ${ip}`));
exports.ExpandableNetworkDetailsTitle = ExpandableNetworkDetailsTitle;
const ExpandableNetworkDetailsPageLink = ({
  expandedNetwork: {
    ip,
    flowTarget
  }
}) => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
  ip: ip,
  flowTarget: flowTarget,
  isButton: true
}, _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.networkDetails.networkDetailsPageLink', {
  defaultMessage: 'View details page'
}));
exports.ExpandableNetworkDetailsPageLink = ExpandableNetworkDetailsPageLink;
const ExpandableNetworkDetails = ({
  contextID,
  expandedNetwork,
  isDraggable
}) => {
  const {
    ip,
    flowTarget
  } = expandedNetwork;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    to,
    from,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const type = _store2.networkModel.NetworkType.details;
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const {
    indicesExist,
    indexPattern,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const [filterQuery, kqlError] = (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    indexPattern,
    queries: [query],
    filters
  });
  const [loading, {
    id,
    networkDetails
  }] = (0, _details2.useNetworkDetails)({
    skip: isInitializing || filterQuery === undefined,
    filterQuery,
    indexNames: selectedPatterns,
    ip
  });
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id,
    filterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const {
    jobNameById
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobNameById)();
  const jobIds = (0, _react.useMemo)(() => Object.keys(jobNameById), [jobNameById]);
  const [isLoadingAnomaliesData, anomaliesData] = (0, _use_anomalies_table_data.useAnomaliesTableData)({
    criteriaFields: (0, _network_to_criteria.networkToCriteria)(ip, flowTarget),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    jobIds,
    aggregationInterval: 'auto'
  });
  return indicesExist ? /*#__PURE__*/_react.default.createElement(_details.IpOverview, {
    contextID: contextID,
    id: id,
    ip: ip,
    data: networkDetails,
    anomaliesData: anomaliesData,
    loading: loading,
    isInDetailsSidePanel: true,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    isDraggable: isDraggable,
    type: type,
    flowTarget: flowTarget,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById
  }) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null);
};
exports.ExpandableNetworkDetails = ExpandableNetworkDetails;