"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _helpers = require("../../../helpers");
var _store = require("../../store");
var _defaults = require("../../store/defaults");
var _timeline = require("../../../../common/types/timeline");
var _use_selector = require("../../../common/hooks/use_selector");
var _event_details = require("./event_details");
var _host_details = require("./host_details");
var _network_details = require("./network_details");
var _user_details = require("./user_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This panel is used in both the main timeline as well as the flyouts on the host, detection, cases, and network pages.
 * To prevent duplication the `isFlyoutView` prop is passed to determine the layout that should be used
 * `tabType` defaults to query and `handleOnPanelClosed` defaults to unsetting the default query tab which is used for the flyout panel
 */
const DetailsPanel = exports.DetailsPanel = /*#__PURE__*/_react.default.memo(({
  browserFields,
  entityType,
  handleOnPanelClosed,
  isFlyoutView,
  runtimeMappings,
  tabType,
  scopeId,
  isReadOnly
}) => {
  var _currentTabDetail$par, _currentTabDetail$par2, _currentTabDetail$par3, _currentTabDetail$par4;
  const dispatch = (0, _reactRedux.useDispatch)();
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _store.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const expandedDetail = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref, _ref2;
    return (_ref = (_ref2 = getScope && getScope(state, scopeId)) !== null && _ref2 !== void 0 ? _ref2 : _defaults.timelineDefaults) === null || _ref === void 0 ? void 0 : _ref.expandedDetail;
  });
  (0, _react.useEffect)(() => {
    /**
     * Removes the flyout from redux when it is unmounted as it's also stored in localStorage
     * This only works when navigating within the app, if navigating via the url bar,
     * the localStorage state will be maintained
     * */
    return () => {
      dispatch(_securitysolutionDataTable.dataTableActions.toggleDetailPanel({
        id: scopeId
      }));
    };
  }, [dispatch, scopeId]);

  // To be used primarily in the flyout scenario where we don't want to maintain the tabType
  const defaultOnPanelClose = (0, _react.useCallback)(() => {
    const scopedActions = (0, _helpers.getScopedActions)(scopeId);
    if (scopedActions) {
      dispatch(scopedActions.toggleDetailPanel({
        id: scopeId
      }));
    }
  }, [dispatch, scopeId]);
  const activeTab = tabType !== null && tabType !== void 0 ? tabType : _timeline.TimelineTabs.query;
  const closePanel = (0, _react.useCallback)(() => {
    if (handleOnPanelClosed) handleOnPanelClosed();else defaultOnPanelClose();
  }, [defaultOnPanelClose, handleOnPanelClosed]);
  if (!expandedDetail) return null;
  const currentTabDetail = expandedDetail[activeTab];
  if (!(currentTabDetail !== null && currentTabDetail !== void 0 && currentTabDetail.panelView)) return null;
  let visiblePanel = null; // store in variable to make return statement more readable
  let panelSize = 's';
  let flyoutUniqueKey = scopeId;
  const contextID = `${scopeId}-${activeTab}`;
  const isDraggable = scopeId === _timeline.TimelineId.active && activeTab === _timeline.TimelineTabs.query;
  if ((currentTabDetail === null || currentTabDetail === void 0 ? void 0 : currentTabDetail.panelView) === 'eventDetail' && currentTabDetail !== null && currentTabDetail !== void 0 && (_currentTabDetail$par = currentTabDetail.params) !== null && _currentTabDetail$par !== void 0 && _currentTabDetail$par.eventId) {
    panelSize = 'm';
    flyoutUniqueKey = currentTabDetail.params.eventId;
    visiblePanel = /*#__PURE__*/_react.default.createElement(_event_details.EventDetailsPanel, {
      browserFields: browserFields,
      entityType: entityType,
      expandedEvent: currentTabDetail === null || currentTabDetail === void 0 ? void 0 : currentTabDetail.params,
      handleOnEventClosed: closePanel,
      isDraggable: isDraggable,
      isFlyoutView: isFlyoutView,
      runtimeMappings: runtimeMappings,
      tabType: activeTab,
      scopeId: scopeId,
      isReadOnly: isReadOnly
    });
  }
  if ((currentTabDetail === null || currentTabDetail === void 0 ? void 0 : currentTabDetail.panelView) === 'hostDetail' && currentTabDetail !== null && currentTabDetail !== void 0 && (_currentTabDetail$par2 = currentTabDetail.params) !== null && _currentTabDetail$par2 !== void 0 && _currentTabDetail$par2.hostName) {
    flyoutUniqueKey = currentTabDetail.params.hostName;
    visiblePanel = /*#__PURE__*/_react.default.createElement(_host_details.HostDetailsPanel, {
      contextID: contextID,
      expandedHost: currentTabDetail === null || currentTabDetail === void 0 ? void 0 : currentTabDetail.params,
      handleOnHostClosed: closePanel,
      isDraggable: isDraggable,
      isFlyoutView: isFlyoutView,
      scopeId: scopeId
    });
  }
  if ((currentTabDetail === null || currentTabDetail === void 0 ? void 0 : currentTabDetail.panelView) === 'userDetail' && currentTabDetail !== null && currentTabDetail !== void 0 && (_currentTabDetail$par3 = currentTabDetail.params) !== null && _currentTabDetail$par3 !== void 0 && _currentTabDetail$par3.userName) {
    flyoutUniqueKey = currentTabDetail.params.userName;
    visiblePanel = /*#__PURE__*/_react.default.createElement(_user_details.UserDetailsPanel, {
      contextID: contextID,
      userName: currentTabDetail.params.userName,
      handleOnClose: closePanel,
      isDraggable: isDraggable,
      isFlyoutView: isFlyoutView,
      scopeId: scopeId
    });
  }
  if ((currentTabDetail === null || currentTabDetail === void 0 ? void 0 : currentTabDetail.panelView) === 'networkDetail' && currentTabDetail !== null && currentTabDetail !== void 0 && (_currentTabDetail$par4 = currentTabDetail.params) !== null && _currentTabDetail$par4 !== void 0 && _currentTabDetail$par4.ip) {
    flyoutUniqueKey = currentTabDetail.params.ip;
    visiblePanel = /*#__PURE__*/_react.default.createElement(_network_details.NetworkDetailsPanel, {
      contextID: contextID,
      expandedNetwork: currentTabDetail === null || currentTabDetail === void 0 ? void 0 : currentTabDetail.params,
      handleOnNetworkClosed: closePanel,
      isDraggable: isDraggable,
      isFlyoutView: isFlyoutView
    });
  }
  return isFlyoutView ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "timeline:details-panel:flyout",
    size: panelSize,
    onClose: closePanel,
    ownFocus: false,
    key: flyoutUniqueKey
  }, visiblePanel) : visiblePanel;
});
DetailsPanel.displayName = 'DetailsPanel';