"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetailsPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _asset_criticality_selector = require("../../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _expandable_host = require("./expandable_host");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflow {
    display: flex;
    flex: 1;
    overflow: hidden;

    .euiFlyoutBody__overflowContent {
      flex: 1;
      overflow-x: hidden;
      overflow-y: scroll;
      margin-bottom: 64px; // account for firefox, which doesn't seem to respect the bottom padding
      padding: ${({
  theme
}) => `${theme.eui.euiSizeXS} ${theme.eui.euiSizeM} 0px`};
    }
  }
`;
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex: 1 0 auto;
`;
const StyledEuiFlexButtonWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-self: flex-start;
  flex: 1 0 auto;
`;
const StyledPanelContent = _styledComponents.default.div`
  display: block;
  height: 100%;
  overflow-y: scroll;
  overflow-x: hidden;
`;
// eslint-disable-next-line react/display-name
const HostDetailsPanel = exports.HostDetailsPanel = /*#__PURE__*/_react.default.memo(({
  contextID,
  scopeId,
  expandedHost,
  handleOnHostClosed,
  isDraggable,
  isFlyoutView
}) => {
  const {
    hostName
  } = expandedHost;
  const entity = (0, _react.useMemo)(() => ({
    name: hostName,
    type: 'host'
  }), [hostName]);
  if (!hostName) {
    return null;
  }
  return isFlyoutView ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_expandable_host.ExpandableHostDetailsTitle, {
    hostName: hostName
  })), /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_expandable_host.ExpandableHostDetailsPageLink, {
    hostName: hostName
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityAccordion, {
    entity: entity
  }), /*#__PURE__*/_react.default.createElement(_expandable_host.ExpandableHostDetails, {
    contextID: contextID,
    scopeId: scopeId,
    hostName: hostName
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    justifyContent: "spaceBetween",
    wrap: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_expandable_host.ExpandableHostDetailsTitle, {
    hostName: hostName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.hostDetails.close', {
      defaultMessage: 'close'
    }),
    onClick: handleOnHostClosed
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(StyledEuiFlexButtonWrapper, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_expandable_host.ExpandableHostDetailsPageLink, {
    hostName: hostName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityAccordion, {
    entity: entity
  }), /*#__PURE__*/_react.default.createElement(StyledPanelContent, null, /*#__PURE__*/_react.default.createElement(_expandable_host.ExpandableHostDetails, {
    contextID: contextID,
    scopeId: scopeId,
    hostName: hostName,
    isDraggable: isDraggable
  })));
});