"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../../../../helpers");
var _store = require("../../../store");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _timeline = require("../../../../../common/types/timeline");
var _defaults = require("../../../store/defaults");
var _use_selector = require("../../../../common/hooks/use_selector");
var _ = require("..");
var _constants = require("../../../../../common/constants");
var _panel_keys = require("../../../../flyout/document_details/shared/constants/panel_keys");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDetailPanel = ({
  entityType,
  isFlyoutView,
  sourcererScope,
  scopeId,
  tabType = _timeline.TimelineTabs.query
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    browserFields,
    selectedPatterns,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const [isSecurityFlyoutEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_EXPANDABLE_FLYOUT_SETTING);
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _store.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const eventDetailsIndex = (0, _react.useMemo)(() => selectedPatterns.join(','), [selectedPatterns]);
  const expandedDetail = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref, _ref2;
    return (_ref = (_ref2 = getScope && getScope(state, scopeId)) !== null && _ref2 !== void 0 ? _ref2 : _defaults.timelineDefaults) === null || _ref === void 0 ? void 0 : _ref.expandedDetail;
  });
  const onPanelClose = (0, _react.useRef)(() => {});
  const noopPanelClose = () => {};
  const shouldShowDetailsPanel = (0, _react.useMemo)(() => {
    var _expandedDetail$tabTy;
    if (tabType && expandedDetail && expandedDetail[tabType] && !!((_expandedDetail$tabTy = expandedDetail[tabType]) !== null && _expandedDetail$tabTy !== void 0 && _expandedDetail$tabTy.panelView)) {
      return true;
    }
    return false;
  }, [expandedDetail, tabType]);
  const scopedActions = (0, _helpers.getScopedActions)(scopeId);

  // We could just surface load details panel, but rather than have users be concerned
  // of the config for a panel, they can just pass the base necessary values to a panel specific function
  const loadDetailsPanel = (0, _react.useCallback)(panelConfig => {
    if (panelConfig && scopedActions) {
      dispatch(scopedActions.toggleDetailPanel({
        ...panelConfig,
        tabType,
        id: scopeId
      }));
    }
  }, [scopedActions, scopeId, dispatch, tabType]);
  const openEventDetailsPanel = (0, _react.useCallback)((eventId, onClose) => {
    if (isSecurityFlyoutEnabled) {
      openFlyout({
        right: {
          id: _panel_keys.DocumentDetailsRightPanelKey,
          params: {
            id: eventId,
            indexName: eventDetailsIndex,
            scopeId
          }
        }
      });
      telemetry.reportDetailsFlyoutOpened({
        location: scopeId,
        panel: 'right'
      });
    } else if (eventId) {
      loadDetailsPanel({
        panelView: 'eventDetail',
        params: {
          eventId,
          indexName: eventDetailsIndex
        }
      });
      onPanelClose.current = onClose !== null && onClose !== void 0 ? onClose : noopPanelClose;
    }
  }, [isSecurityFlyoutEnabled, openFlyout, eventDetailsIndex, scopeId, telemetry, loadDetailsPanel]);
  const handleOnDetailsPanelClosed = (0, _react.useCallback)(() => {
    if (isSecurityFlyoutEnabled) return;
    if (onPanelClose.current) onPanelClose.current();
    if (scopedActions) {
      dispatch(scopedActions.toggleDetailPanel({
        tabType,
        id: scopeId
      }));
    }
  }, [isSecurityFlyoutEnabled, scopedActions, dispatch, tabType, scopeId]);
  const DetailsPanel = (0, _react.useMemo)(() => shouldShowDetailsPanel ? /*#__PURE__*/_react.default.createElement(_.DetailsPanel, {
    browserFields: browserFields,
    entityType: entityType,
    handleOnPanelClosed: handleOnDetailsPanelClosed,
    isFlyoutView: isFlyoutView,
    runtimeMappings: runtimeMappings,
    tabType: tabType,
    scopeId: scopeId
  }) : null, [browserFields, entityType, handleOnDetailsPanelClosed, isFlyoutView, runtimeMappings, shouldShowDetailsPanel, tabType, scopeId]);
  return {
    openEventDetailsPanel,
    shouldShowDetailsPanel,
    DetailsPanel
  };
};
exports.useDetailPanel = useDetailPanel;