"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSubAction = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../../../../common/lib/kibana/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSubAction = ({
  connectorId,
  subAction,
  subActionParams,
  disabled = false,
  ...rest
}) => {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: ['useSubAction', connectorId, subAction, subActionParams],
    queryFn: ({
      signal
    }) => (0, _public.executeAction)({
      id: connectorId,
      params: {
        subAction,
        subActionParams
      },
      http,
      signal
    }),
    enabled: !disabled && !!connectorId && !!subAction,
    ...rest
  });
};
exports.useSubAction = useSubAction;