"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutFooterComponent = exports.FlyoutFooter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _helpers = require("../../../../../helpers");
var _take_action_dropdown = require("../../../../../detections/components/take_action_dropdown");
var _use_add_exception_flyout = require("../../../../../detections/components/alerts_table/timeline_actions/use_add_exception_flyout");
var _alert_context_menu = require("../../../../../detections/components/alerts_table/timeline_actions/alert_context_menu");
var _event_filters_flyout = require("../../../../../management/pages/event_filters/view/components/event_filters_flyout");
var _use_event_filter_modal = require("../../../../../detections/components/alerts_table/timeline_actions/use_event_filter_modal");
var _helpers2 = require("../../../../../detections/components/host_isolation/helpers");
var _osquery_flyout = require("../../../../../detections/components/osquery/osquery_flyout");
var _use_refetch_by_scope = require("./use_refetch_by_scope");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutFooterComponent = ({
  detailsData,
  detailsEcsData,
  handleOnEventClosed,
  isHostIsolationPanelOpen,
  isReadOnly,
  loadingEventDetails,
  onAddIsolationStatusClick,
  scopeId,
  refetchFlyoutData
}) => {
  var _detailsEcsData$kiban;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const flyoutZIndex = (0, _react.useMemo)(() => ({
    style: `z-index: ${euiTheme.levels.flyout + 3}`
  }), [euiTheme]);
  const alertId = detailsEcsData !== null && detailsEcsData !== void 0 && (_detailsEcsData$kiban = detailsEcsData.kibana) !== null && _detailsEcsData$kiban !== void 0 && _detailsEcsData$kiban.alert ? detailsEcsData === null || detailsEcsData === void 0 ? void 0 : detailsEcsData._id : null;
  const ruleIndexRaw = (0, _react.useMemo)(() => {
    var _find$values, _find, _find2;
    return (_find$values = (_find = (0, _fp.find)({
      category: 'signal',
      field: 'signal.rule.index'
    }, detailsData)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : (_find2 = (0, _fp.find)({
      category: 'kibana',
      field: 'kibana.alert.rule.parameters.index'
    }, detailsData)) === null || _find2 === void 0 ? void 0 : _find2.values;
  }, [detailsData]);
  const ruleIndex = (0, _react.useMemo)(() => Array.isArray(ruleIndexRaw) ? ruleIndexRaw : undefined, [ruleIndexRaw]);
  const ruleDataViewIdRaw = (0, _react.useMemo)(() => {
    var _find$values2, _find3, _find4;
    return (_find$values2 = (_find3 = (0, _fp.find)({
      category: 'signal',
      field: 'signal.rule.data_view_id'
    }, detailsData)) === null || _find3 === void 0 ? void 0 : _find3.values) !== null && _find$values2 !== void 0 ? _find$values2 : (_find4 = (0, _fp.find)({
      category: 'kibana',
      field: 'kibana.alert.rule.parameters.data_view_id'
    }, detailsData)) === null || _find4 === void 0 ? void 0 : _find4.values;
  }, [detailsData]);
  const ruleDataViewId = (0, _react.useMemo)(() => Array.isArray(ruleDataViewIdRaw) ? ruleDataViewIdRaw[0] : undefined, [ruleDataViewIdRaw]);
  const addExceptionModalWrapperData = (0, _react.useMemo)(() => [{
    category: 'signal',
    field: 'signal.rule.id',
    name: 'ruleId'
  }, {
    category: 'signal',
    field: 'signal.rule.rule_id',
    name: 'ruleRuleId'
  }, {
    category: 'signal',
    field: 'signal.rule.name',
    name: 'ruleName'
  }, {
    category: 'signal',
    field: 'kibana.alert.workflow_status',
    name: 'alertStatus'
  }, {
    category: '_id',
    field: '_id',
    name: 'eventId'
  }].reduce((acc, curr) => ({
    ...acc,
    [curr.name]: (0, _helpers2.getFieldValue)({
      category: curr.category,
      field: curr.field
    }, detailsData)
  }), {}), [detailsData]);
  const {
    refetch: refetchAll
  } = (0, _use_refetch_by_scope.useRefetchByScope)({
    scopeId
  });
  const {
    exceptionFlyoutType,
    openAddExceptionFlyout,
    onAddExceptionTypeClick,
    onAddExceptionCancel,
    onAddExceptionConfirm
  } = (0, _use_add_exception_flyout.useExceptionFlyout)({
    refetch: refetchAll,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId)
  });
  const {
    closeAddEventFilterModal,
    isAddEventFilterModalOpen,
    onAddEventFilterClick
  } = (0, _use_event_filter_modal.useEventFilterModal)();
  const [isOsqueryFlyoutOpenWithAgentId, setOsqueryFlyoutOpenWithAgentId] = (0, _react.useState)(null);
  const closeOsqueryFlyout = (0, _react.useCallback)(() => {
    setOsqueryFlyoutOpenWithAgentId(null);
  }, [setOsqueryFlyoutOpenWithAgentId]);
  if (isReadOnly) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "side-panel-flyout-footer",
    "data-test-subj": "side-panel-flyout-footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, detailsEcsData && /*#__PURE__*/_react.default.createElement(_take_action_dropdown.TakeActionDropdown, {
    detailsData: detailsData,
    ecsData: detailsEcsData,
    handleOnEventClosed: handleOnEventClosed,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    loadingEventDetails: loadingEventDetails,
    onAddEventFilterClick: onAddEventFilterClick,
    onAddExceptionTypeClick: onAddExceptionTypeClick,
    onAddIsolationStatusClick: onAddIsolationStatusClick,
    refetchFlyoutData: refetchFlyoutData,
    refetch: refetchAll,
    scopeId: scopeId,
    onOsqueryClick: setOsqueryFlyoutOpenWithAgentId
  })))), openAddExceptionFlyout && addExceptionModalWrapperData.ruleId != null && addExceptionModalWrapperData.ruleRuleId != null && addExceptionModalWrapperData.eventId != null && /*#__PURE__*/_react.default.createElement(_alert_context_menu.AddExceptionFlyoutWrapper, (0, _extends2.default)({}, addExceptionModalWrapperData, {
    ruleIndices: ruleIndex,
    ruleDataViewId: ruleDataViewId,
    exceptionListType: exceptionFlyoutType,
    onCancel: onAddExceptionCancel,
    onConfirm: onAddExceptionConfirm
  })), isAddEventFilterModalOpen && detailsEcsData != null && /*#__PURE__*/_react.default.createElement(_event_filters_flyout.EventFiltersFlyout, {
    data: detailsEcsData,
    onCancel: closeAddEventFilterModal
    // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
    ,
    maskProps: flyoutZIndex // we need this flyout to be above the timeline flyout (which has a z-index of 1002)
  }), isOsqueryFlyoutOpenWithAgentId && detailsEcsData != null && /*#__PURE__*/_react.default.createElement(_osquery_flyout.OsqueryFlyout, {
    agentId: isOsqueryFlyoutOpenWithAgentId,
    defaultValues: alertId ? {
      alertIds: [alertId]
    } : undefined,
    onClose: closeOsqueryFlyout,
    ecsData: detailsEcsData
  }));
};
exports.FlyoutFooterComponent = FlyoutFooterComponent;
const FlyoutFooter = exports.FlyoutFooter = /*#__PURE__*/_react.default.memo(FlyoutFooterComponent);