"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOGGLE_EXPAND_EVENT_DETAILS = exports.DELETE_NOTE_ERROR = exports.DELETE_NOTE_CONFIRM = exports.DELETE_NOTE = exports.CANCEL_DELETE_NOTE = exports.AN_UNKNOWN_USER = exports.ADDED_A_NOTE = exports.ADDED_A_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOGGLE_EXPAND_EVENT_DETAILS = exports.TOGGLE_EXPAND_EVENT_DETAILS = _i18n.i18n.translate('xpack.securitySolution.timeline.toggleEventDetailsTitle', {
  defaultMessage: 'Expand event details'
});
const ADDED_A_NOTE = exports.ADDED_A_NOTE = _i18n.i18n.translate('xpack.securitySolution.timeline.addedANoteLabel', {
  defaultMessage: 'added a note'
});
const ADDED_A_DESCRIPTION = exports.ADDED_A_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.addedADescriptionLabel', {
  defaultMessage: 'added description'
});
const AN_UNKNOWN_USER = exports.AN_UNKNOWN_USER = _i18n.i18n.translate('xpack.securitySolution.timeline.anUnknownUserLabel', {
  defaultMessage: 'an unknown user'
});
const DELETE_NOTE_ERROR = error => _i18n.i18n.translate('xpack.securitySolution.timeline.deleteNoteError', {
  defaultMessage: 'An error occurred deleting note {error}',
  values: {
    error
  }
});
exports.DELETE_NOTE_ERROR = DELETE_NOTE_ERROR;
const DELETE_NOTE = exports.DELETE_NOTE = _i18n.i18n.translate('xpack.securitySolution.timeline.deleteNoteLabel', {
  defaultMessage: 'Delete Note'
});
const CANCEL_DELETE_NOTE = exports.CANCEL_DELETE_NOTE = _i18n.i18n.translate('xpack.securitySolution.timeline.cancelDeleteNoteLabel', {
  defaultMessage: 'Keep Note'
});
const DELETE_NOTE_CONFIRM = exports.DELETE_NOTE_CONFIRM = _i18n.i18n.translate('xpack.securitySolution.timeline.promptDeleteNoteLabel', {
  defaultMessage: 'Delete timeline note?'
});