"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotePreviewsContainer = exports.NotePreviews = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _panel_keys = require("../../../../flyout/document_details/shared/constants/panel_keys");
var _empty_value = require("../../../../common/components/empty_value");
var _markdown_editor = require("../../../../common/components/markdown_editor");
var _store = require("../../../store");
var _helpers = require("../../timeline/body/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline = require("../../../../../common/types/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _model = require("../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_delete_note = require("./hooks/use_delete_note");
var _selectors = require("../../timeline/tabs/notes/selectors");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotePreviewsContainer = exports.NotePreviewsContainer = _styledComponents.default.section`
  padding-top: ${({
  theme
}) => `${theme.eui.euiSizeS}`};
`;
NotePreviewsContainer.displayName = 'NotePreviewsContainer';
const ToggleEventDetailsButtonComponent = ({
  eventId,
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const [isSecurityFlyoutEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_EXPANDABLE_FLYOUT_SETTING);
  const expandableTimelineFlyoutEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('expandableTimelineFlyoutEnabled');
  const handleClick = (0, _react.useCallback)(() => {
    const indexName = selectedPatterns.join(',');
    if (isSecurityFlyoutEnabled && expandableTimelineFlyoutEnabled) {
      openFlyout({
        right: {
          id: _panel_keys.DocumentDetailsRightPanelKey,
          params: {
            id: eventId,
            indexName,
            scopeId: timelineId
          }
        }
      });
      telemetry.reportDetailsFlyoutOpened({
        location: timelineId,
        panel: 'right'
      });
    } else {
      dispatch(_store.timelineActions.toggleDetailPanel({
        panelView: 'eventDetail',
        tabType: _timeline.TimelineTabs.notes,
        id: timelineId,
        params: {
          eventId,
          indexName
        }
      }));
    }
  }, [dispatch, eventId, expandableTimelineFlyoutEnabled, isSecurityFlyoutEnabled, openFlyout, selectedPatterns, telemetry, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    title: i18n.TOGGLE_EXPAND_EVENT_DETAILS,
    "aria-label": i18n.TOGGLE_EXPAND_EVENT_DETAILS,
    color: "text",
    iconType: "arrowRight",
    onClick: handleClick
  });
};
const ToggleEventDetailsButton = /*#__PURE__*/_react.default.memo(ToggleEventDetailsButtonComponent);
const DeleteNoteConfirm = /*#__PURE__*/_react.default.memo(({
  closeModal,
  confirmModal
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18n.DELETE_NOTE_CONFIRM,
    onCancel: closeModal,
    onConfirm: confirmModal,
    cancelButtonText: i18n.CANCEL_DELETE_NOTE,
    confirmButtonText: i18n.DELETE_NOTE,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  });
});
DeleteNoteConfirm.displayName = 'DeleteNoteConfirm';
const DeleteNoteButton = /*#__PURE__*/_react.default.memo(({
  noteId,
  eventId,
  confirmingNoteId,
  timelineId,
  eventIdToNoteIds,
  savedObjectId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const {
    mutate,
    isLoading
  } = (0, _use_delete_note.useDeleteNote)(noteId, eventId, eventIdToNoteIds, savedObjectId);
  const handleOpenDeleteModal = (0, _react.useCallback)(() => {
    setShowModal(true);
    dispatch(_store.timelineActions.setConfirmingNoteId({
      confirmingNoteId: noteId,
      id: timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active
    }));
  }, [noteId, dispatch, timelineId]);
  const handleCancelDelete = (0, _react.useCallback)(() => {
    setShowModal(false);
    dispatch(_store.timelineActions.setConfirmingNoteId({
      confirmingNoteId: null,
      id: timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active
    }));
  }, [dispatch, timelineId]);
  const handleConfirmDelete = (0, _react.useCallback)(() => {
    mutate(savedObjectId);
    setShowModal(false);
    dispatch(_store.timelineActions.setConfirmingNoteId({
      confirmingNoteId: null,
      id: timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active
    }));
  }, [mutate, savedObjectId, dispatch, timelineId]);
  const disableDelete = (0, _react.useMemo)(() => {
    return isLoading || savedObjectId == null;
  }, [isLoading, savedObjectId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    title: i18n.DELETE_NOTE,
    "aria-label": i18n.DELETE_NOTE,
    "data-test-subj": 'delete-note',
    color: "text",
    iconType: "trash",
    onClick: handleOpenDeleteModal,
    disabled: disableDelete
  }), confirmingNoteId === noteId && showModal ? /*#__PURE__*/_react.default.createElement(DeleteNoteConfirm, {
    closeModal: handleCancelDelete,
    confirmModal: handleConfirmDelete
  }) : null);
});
DeleteNoteButton.displayName = 'DeleteNoteButton';
const NoteActions = /*#__PURE__*/_react.default.memo(({
  eventId,
  timelineId,
  noteId,
  confirmingNoteId,
  eventIdToNoteIds,
  savedObjectId
}) => {
  return eventId && timelineId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ToggleEventDetailsButton, {
    eventId: eventId,
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(DeleteNoteButton, {
    noteId: noteId,
    eventId: eventId,
    confirmingNoteId: confirmingNoteId,
    savedObjectId: savedObjectId,
    timelineId: timelineId,
    eventIdToNoteIds: eventIdToNoteIds
  })) : /*#__PURE__*/_react.default.createElement(DeleteNoteButton, {
    noteId: noteId,
    eventId: eventId,
    confirmingNoteId: confirmingNoteId,
    savedObjectId: savedObjectId,
    timelineId: timelineId,
    eventIdToNoteIds: eventIdToNoteIds
  });
});
NoteActions.displayName = 'NoteActions';
/**
 * Renders a preview of a note in the All / Open Timelines table
 */

const NotePreviews = exports.NotePreviews = /*#__PURE__*/_react.default.memo(({
  notes,
  timelineId,
  showTimelineDescription
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const getTimelineNotes = (0, _react.useMemo)(() => (0, _selectors.getTimelineNoteSelector)(), []);
  const timeline = (0, _use_selector.useDeepEqualSelector)(state => getTimeline(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active));
  const timelineNotes = (0, _use_selector.useDeepEqualSelector)(state => getTimelineNotes(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active));
  const eventIdToNoteIds = timelineNotes === null || timelineNotes === void 0 ? void 0 : timelineNotes.eventIdToNoteIds;
  const descriptionList = (0, _react.useMemo)(() => showTimelineDescription && timelineId && timeline !== null && timeline !== void 0 && timeline.description ? [{
    username: (0, _empty_value.defaultToEmptyTag)(timeline.updatedBy),
    event: i18n.ADDED_A_DESCRIPTION,
    'data-test-subj': 'note-preview-description',
    id: 'note-preview-description',
    timestamp: timeline.updated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      "data-test-subj": "updated",
      value: new Date(timeline.updated)
    }) : (0, _empty_value.getEmptyValue)(),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, timeline.description),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      "data-test-subj": "avatar",
      name: timeline.updatedBy != null ? timeline.updatedBy : '?',
      size: "l"
    }),
    actions: null
  }] : [], [timeline, timelineId, showTimelineDescription]);
  const notesList = (0, _react.useMemo)(() => (0, _fp.uniqBy)('savedObjectId', notes).map(note => {
    var _note$eventId, _note$updatedBy, _note$note;
    const eventId = eventIdToNoteIds != null ? Object.entries(eventIdToNoteIds).reduce((acc, [id, noteIds]) => {
      var _note$noteId;
      return noteIds.includes((_note$noteId = note.noteId) !== null && _note$noteId !== void 0 ? _note$noteId : '') ? id : acc;
    }, null) : (_note$eventId = note.eventId) !== null && _note$eventId !== void 0 ? _note$eventId : null;
    return {
      'data-test-subj': `note-preview-${note.savedObjectId}`,
      username: (0, _empty_value.defaultToEmptyTag)(note.updatedBy),
      event: i18n.ADDED_A_NOTE,
      timestamp: note.updated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        "data-test-subj": "updated",
        value: new Date(note.updated)
      }) : (0, _empty_value.getEmptyValue)(),
      children: /*#__PURE__*/_react.default.createElement("div", {
        className: _helpers.NOTE_CONTENT_CLASS_NAME,
        tabIndex: 0
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
        "data-test-subj": "screenReaderOnlyUserAddedANote"
      }, /*#__PURE__*/_react.default.createElement("p", null, `${(_note$updatedBy = note.updatedBy) !== null && _note$updatedBy !== void 0 ? _note$updatedBy : i18n.AN_UNKNOWN_USER} ${i18n.ADDED_A_NOTE}`)), /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, (_note$note = note.note) !== null && _note$note !== void 0 ? _note$note : '')),
      actions: /*#__PURE__*/_react.default.createElement(NoteActions, {
        eventId: eventId,
        timelineId: timelineId,
        noteId: note.noteId,
        savedObjectId: note.savedObjectId,
        confirmingNoteId: timeline === null || timeline === void 0 ? void 0 : timeline.confirmingNoteId,
        eventIdToNoteIds: eventIdToNoteIds
      }),
      timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        "data-test-subj": "avatar",
        name: note.updatedBy != null ? note.updatedBy : '?',
        size: "l"
      })
    };
  }), [eventIdToNoteIds, notes, timelineId, timeline === null || timeline === void 0 ? void 0 : timeline.confirmingNoteId]);
  const commentList = (0, _react.useMemo)(() => [...descriptionList, ...notesList], [descriptionList, notesList]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    "data-test-subj": "note-comment-list",
    comments: commentList
  });
});
NotePreviews.displayName = 'NotePreviews';