"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectionsAreValid = exports.sanatizeValue = exports.operatorLabels = exports.getQueryOperatorFromSelection = exports.getFieldNames = exports.getExcludedFromSelection = exports.getCategorizedFieldNames = exports.EMPTY_ARRAY_RESULT = void 0;
var _fp = require("lodash/fp");
var _timeline = require("../../../../common/api/timeline");
var _source = require("../../../common/containers/source");
var _data_provider = require("../timeline/data_providers/data_provider");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** The list of operators to display in the `Operator` select  */
const operatorLabels = exports.operatorLabels = [{
  label: i18n.IS
}, {
  label: i18n.IS_NOT
}, {
  label: i18n.IS_ONE_OF
}, {
  label: i18n.IS_NOT_ONE_OF
}, {
  label: i18n.EXISTS
}, {
  label: i18n.DOES_NOT_EXIST
}];
const EMPTY_ARRAY_RESULT = exports.EMPTY_ARRAY_RESULT = [];

/** Returns the names of fields in a category */
const getFieldNames = category => category.fields != null && Object.keys(category.fields).length > 0 ? Object.keys(category.fields) : EMPTY_ARRAY_RESULT;

/** Returns all field names by category, for display in an `EuiComboBox`  */
exports.getFieldNames = getFieldNames;
const getCategorizedFieldNames = browserFields => !browserFields ? EMPTY_ARRAY_RESULT : Object.keys(browserFields).sort().map(categoryId => ({
  label: categoryId,
  options: getFieldNames(browserFields[categoryId]).map(fieldId => ({
    label: fieldId
  }))
}));

/** Returns true if the specified field name is valid */
exports.getCategorizedFieldNames = getCategorizedFieldNames;
const selectionsAreValid = ({
  browserFields,
  selectedField,
  selectedOperator,
  type
}) => {
  const fieldId = selectedField.length > 0 ? selectedField[0].label : '';
  const operator = selectedOperator.length > 0 ? selectedOperator[0].label : '';
  const fieldIsValid = browserFields && (0, _source.getAllFieldsByName)(browserFields)[fieldId] != null;
  const operatorIsValid = (0, _fp.findIndex)(o => o.label === operator, operatorLabels) !== -1;
  const isOneOfOperatorSelectionWithTemplate = type === _timeline.DataProviderType.template && (operator === i18n.IS_ONE_OF || operator === i18n.IS_NOT_ONE_OF);
  return fieldIsValid && operatorIsValid && !isOneOfOperatorSelectionWithTemplate;
};

/** Returns a `QueryOperator` based on the user's Operator selection */
exports.selectionsAreValid = selectionsAreValid;
const getQueryOperatorFromSelection = selectedOperator => {
  const selection = selectedOperator.length > 0 ? selectedOperator[0].label : '';
  switch (selection) {
    case i18n.IS: // fall through
    case i18n.IS_NOT:
      return _data_provider.IS_OPERATOR;
    case i18n.IS_ONE_OF: // fall through
    case i18n.IS_NOT_ONE_OF:
      return _data_provider.IS_ONE_OF_OPERATOR;
    case i18n.EXISTS: // fall through
    case i18n.DOES_NOT_EXIST:
      return _data_provider.EXISTS_OPERATOR;
    default:
      return _data_provider.IS_OPERATOR;
  }
};

/**
 * Returns `true` when the search excludes results that match the specified data provider
 */
exports.getQueryOperatorFromSelection = getQueryOperatorFromSelection;
const getExcludedFromSelection = selectedOperator => {
  const selection = selectedOperator.length > 0 ? selectedOperator[0].label : '';
  switch (selection) {
    case i18n.IS_NOT: // fall through
    case i18n.IS_NOT_ONE_OF:
    case i18n.DOES_NOT_EXIST:
      return true;
    default:
      return false;
  }
};

/** Ensure that a value passed to ControlledDefaultInput is not an array */
exports.getExcludedFromSelection = getExcludedFromSelection;
const sanatizeValue = value => {
  if (Array.isArray(value)) {
    return value.length ? `${value[0]}` : '';
  }
  return `${value}`;
};
exports.sanatizeValue = sanatizeValue;