"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENT_DURATION_FIELD_NAME = exports.Duration = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../common/components/draggables");
var _formatted_duration = require("../formatted_duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EVENT_DURATION_FIELD_NAME = exports.EVENT_DURATION_FIELD_NAME = 'event.duration';

/**
 * Renders draggable text containing the value of a field representing a
 * duration of time, (e.g. `event.duration`)
 */
const Duration = exports.Duration = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fieldName,
  fieldType,
  isAggregatable,
  isDraggable,
  value
}) => isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `duration-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
  fieldType: fieldType,
  isAggregatable: isAggregatable,
  isDraggable: isDraggable,
  field: fieldName,
  tooltipContent: null,
  value: value
}, /*#__PURE__*/_react.default.createElement(_formatted_duration.FormattedDuration, {
  maybeDurationNanoseconds: value,
  tooltipTitle: fieldName
})) : /*#__PURE__*/_react.default.createElement(_formatted_duration.FormattedDuration, {
  maybeDurationNanoseconds: value,
  tooltipTitle: fieldName
}));
Duration.displayName = 'Duration';