"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddTimelineButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_create_timeline = require("../../hooks/use_create_timeline");
var _timeline = require("../../../../common/api/timeline");
var _open_timeline_modal = require("../open_timeline/open_timeline_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionTimelineToHide = ['createFrom'];
/**
 * Plus button that opens a popover with options to create a new timeline, a new timeline template or open an existing timeline.
 * The component is used in the timeline bottom_bar.
 */
const AddTimelineButton = exports.AddTimelineButton = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [showTimelineModal, setShowTimelineModal] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setPopover(!isPopoverOpen), [isPopoverOpen]);
  const closeTimelineModal = (0, _react.useCallback)(() => setShowTimelineModal(false), []);
  const openTimelineModal = (0, _react.useCallback)(() => {
    togglePopover();
    setShowTimelineModal(true);
  }, [togglePopover]);
  const createNewTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId,
    timelineType: _timeline.TimelineType.default,
    onClick: togglePopover
  });
  const createNewTimelineTemplate = (0, _use_create_timeline.useCreateTimeline)({
    timelineId,
    timelineType: _timeline.TimelineType.template,
    onClick: togglePopover
  });
  const handleCreateNewTimeline = (0, _react.useCallback)(async () => {
    await createNewTimeline();
  }, [createNewTimeline]);
  const handleCreateNewTimelineTemplate = (0, _react.useCallback)(async () => {
    await createNewTimelineTemplate();
  }, [createNewTimelineTemplate]);
  const plusButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "plusInCircle",
    iconSize: "m",
    color: "primary",
    "data-test-subj": "timeline-bottom-bar-open-button",
    "aria-label": i18n.ADD_TIMELINE,
    onClick: togglePopover
  }), [togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: plusButton,
    isOpen: isPopoverOpen,
    closePopover: () => setPopover,
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    color: "text",
    "data-test-subj": "timeline-bottom-bar-create-new-timeline",
    onClick: handleCreateNewTimeline
  }, i18n.NEW_TIMELINE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    color: "text",
    "data-test-subj": "timeline-bottom-bar-create-new-timeline-template",
    onClick: handleCreateNewTimelineTemplate
  }, i18n.NEW_TEMPLATE_TIMELINE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "folderOpen",
    color: "text",
    "data-test-subj": "timeline-bottom-bar-open-timeline",
    onClick: openTimelineModal
  }, i18n.OPEN_TIMELINE))))), showTimelineModal ? /*#__PURE__*/_react.default.createElement(_open_timeline_modal.OpenTimelineModal, {
    onClose: closeTimelineModal,
    hideActions: actionTimelineToHide
  }) : null);
});
AddTimelineButton.displayName = 'AddTimelineButton';