"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentRelatedEventFetcher = CurrentRelatedEventFetcher;
var _lodash = require("lodash");
var selectors = _interopRequireWildcard(require("../selectors"));
var _action = require("../data/action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * @description - This api is called after every state change.
 * If the current view is the `eventDetail` view it will request the event details from the server.
 * @export
 * @param {DataAccessLayer} dataAccessLayer
 * @param {MiddlewareAPI<Dispatch<Action>, State>} api
 * @returns {() => void}
 */
function CurrentRelatedEventFetcher(dataAccessLayer, api) {
  const last = {};
  return async id => {
    const state = api.getState();
    if (!last[id]) {
      last[id] = undefined;
    }
    const newParams = selectors.panelViewAndParameters(state.analyzer[id]);
    const indices = selectors.eventIndices(state.analyzer[id]);
    const oldParams = last[id];
    last[id] = newParams;

    // If the panel view params have changed and the current panel view is the `eventDetail`, then fetch the event details for that eventID.
    if (!(0, _lodash.isEqual)(newParams, oldParams) && newParams.panelView === 'eventDetail') {
      const currentEventID = newParams.panelParameters.eventID;
      const currentNodeID = newParams.panelParameters.nodeID;
      const currentEventCategory = newParams.panelParameters.eventCategory;
      const currentEventTimestamp = newParams.panelParameters.eventTimestamp;
      const winlogRecordID = newParams.panelParameters.winlogRecordID;
      api.dispatch((0, _action.appRequestedCurrentRelatedEventData)({
        id
      }));
      const detectedBounds = selectors.detectedBounds(state.analyzer[id]);
      const timeRangeFilters = detectedBounds !== undefined ? undefined : selectors.timeRangeFilters(state.analyzer[id]);
      let result = null;
      try {
        result = await dataAccessLayer.event({
          nodeID: currentNodeID,
          eventCategory: [currentEventCategory],
          eventTimestamp: currentEventTimestamp,
          eventID: currentEventID,
          winlogRecordID,
          indexPatterns: indices,
          timeRange: timeRangeFilters
        });
      } catch (error) {
        api.dispatch((0, _action.serverFailedToReturnCurrentRelatedEventData)({
          id
        }));
      }
      if (result) {
        api.dispatch((0, _action.serverReturnedCurrentRelatedEventData)({
          id,
          relatedEvent: result
        }));
      } else {
        api.dispatch((0, _action.serverFailedToReturnCurrentRelatedEventData)({
          id
        }));
      }
    }
  };
}