"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _lazy_endpoint_agent_tamper_protection_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_agent_tamper_protection_extension");
var _translations = require("./common/translations");
var _constants = require("../common/constants");
var _links = require("./common/links");
var _deep_links = require("./common/links/deep_links");
var _lazy_endpoint_policy_edit_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_edit_extension");
var _lazy_endpoint_policy_create_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_extension");
var _lazy_endpoint_policy_create_multi_step_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_multi_step_extension");
var _lazy_endpoint_package_custom_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_package_custom_extension");
var _lazy_endpoint_policy_response_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_response_extension");
var _lazy_endpoint_generic_errors_list = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_generic_errors_list");
var _experimental_features = require("../common/experimental_features");
var _lazy_endpoint_custom_assets_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_custom_assets_extension");
var _lazy_custom_cribl_extension = require("./security_integrations/cribl/components/lazy_custom_cribl_extension");
var _plugin_contract = require("./plugin_contract");
var _plugin_services = require("./plugin_services");
var _external_reference = require("./cases/attachments/external_reference");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class Plugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    (0, _defineProperty2.default)(this, "contract", void 0);
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "storage", new _public2.Storage(localStorage));
    // Lazily instantiated dependencies
    (0, _defineProperty2.default)(this, "_subPlugins", void 0);
    (0, _defineProperty2.default)(this, "_store", void 0);
    (0, _defineProperty2.default)(this, "_actionsRegistered", false);
    (0, _defineProperty2.default)(this, "_alertsTableRegistered", false);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []).features;
    this.contract = new _plugin_contract.PluginContract(this.experimentalFeatures);
    this.services = new _plugin_services.PluginServices(this.config, this.experimentalFeatures, this.contract, initializerContext.env.packageInfo);
  }
  setup(core, plugins) {
    var _plugins$cases;
    this.services.setup(core, plugins);
    const {
      home,
      triggersActionsUi,
      usageCollection,
      management
    } = plugins;
    const assistantManagementTitle = _i18n.i18n.translate('xpack.securitySolution.securityAiAssistantManagement.app.title', {
      defaultMessage: 'AI Assistant for Security'
    });
    if (home) {
      home.featureCatalogue.registerSolution({
        id: _constants.APP_ID,
        title: _translations.SOLUTION_NAME,
        description: _i18n.i18n.translate('xpack.securitySolution.featureCatalogueDescription', {
          defaultMessage: 'Prevent, collect, detect, and respond to threats for unified protection across your infrastructure.'
        }),
        icon: 'logoSecurity',
        path: _constants.APP_PATH,
        order: 300
      });
      home.featureCatalogue.register({
        id: 'ai_assistant_security',
        title: assistantManagementTitle,
        description: _i18n.i18n.translate('xpack.securitySolution.securityAiAssistantManagement.app.description', {
          defaultMessage: 'Manage your AI Assistant for Security.'
        }),
        icon: 'sparkles',
        path: '/app/management/kibana/securityAiAssistantManagement',
        showOnHomePage: false,
        category: 'admin'
      });
      if (management) {
        management.sections.section.kibana.registerApp({
          id: 'securityAiAssistantManagement',
          title: assistantManagementTitle,
          hideFromSidebar: true,
          order: 1,
          mount: async params => {
            // required to show the alert table inside cases
            const {
              alertsTableConfigurationRegistry
            } = plugins.triggersActionsUi;
            const {
              registerAlertsTableConfiguration
            } = await this.lazyRegisterAlertsTableConfiguration();
            registerAlertsTableConfiguration(alertsTableConfigurationRegistry, this.storage);
            const [coreStart, startPlugins] = await core.getStartServices();
            const subPlugins = await this.startSubPlugins(this.storage, coreStart, startPlugins);
            const store = await this.store(coreStart, startPlugins, subPlugins);
            const services = await this.services.generateServices(coreStart, startPlugins);
            await this.registerActions(store, params.history, services);
            const {
              renderApp
            } = await this.lazyApplicationDependencies();
            const {
              ManagementSettings
            } = await this.lazyAssistantSettingsManagement();
            return renderApp({
              ...params,
              services,
              store,
              usageCollection: plugins.usageCollection,
              children: /*#__PURE__*/_react.default.createElement(ManagementSettings, null)
            });
          }
        });
      }
    }
    const mount = async params => {
      const [coreStart, startPlugins] = await core.getStartServices();
      const services = await this.services.generateServices(coreStart, startPlugins, params);
      const subPlugins = await this.startSubPlugins(this.storage, coreStart, startPlugins);
      const store = await this.store(coreStart, startPlugins, subPlugins);
      const {
        renderApp
      } = await this.lazyApplicationDependencies();
      const {
        getSubPluginRoutesByCapabilities
      } = await this.lazyHelpersForRoutes();
      await this.registerActions(store, params.history, services);
      await this.registerAlertsTableConfiguration(triggersActionsUi);
      const subPluginRoutes = getSubPluginRoutesByCapabilities(subPlugins, services);
      return renderApp({
        ...params,
        services,
        store,
        usageCollection,
        subPluginRoutes
      });
    };

    // Register main Security Solution plugin
    core.application.register({
      id: _constants.APP_UI_ID,
      title: _translations.SOLUTION_NAME,
      appRoute: _constants.APP_PATH,
      category: _public.DEFAULT_APP_CATEGORIES.security,
      updater$: this.appUpdater$,
      visibleIn: ['globalSearch', 'home', 'kibanaOverview'],
      euiIconType: _constants.APP_ICON_SOLUTION,
      mount
    });

    // Register legacy SIEM app for backward compatibility
    core.application.register({
      id: 'siem',
      appRoute: 'app/siem',
      title: 'SIEM',
      visibleIn: [],
      mount: async params => {
        const [coreStart] = await core.getStartServices();
        const {
          manageOldSiemRoutes
        } = await this.lazyHelpersForRoutes();
        const subscription = this.appUpdater$.subscribe(() => {
          // wait for app initialization to set the links
          manageOldSiemRoutes(coreStart);
          subscription.unsubscribe();
        });
        return () => true;
      }
    });
    (_plugins$cases = plugins.cases) === null || _plugins$cases === void 0 ? void 0 : _plugins$cases.attachmentFramework.registerExternalReference((0, _external_reference.getExternalReferenceAttachmentEndpointRegular)());
    return this.contract.getSetupContract();
  }
  start(core, plugins) {
    this.services.start(core, plugins);
    if (plugins.fleet) {
      const {
        registerExtension
      } = plugins.fleet;
      const registerOptions = {
        coreStart: core,
        depsStart: plugins,
        services: {
          upsellingService: this.contract.upsellingService
        }
      };
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-edit',
        Component: (0, _lazy_endpoint_policy_edit_extension.getLazyEndpointPolicyEditExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-response',
        Component: (0, _lazy_endpoint_policy_response_extension.getLazyEndpointPolicyResponseExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-generic-errors-list',
        Component: (0, _lazy_endpoint_generic_errors_list.getLazyEndpointGenericErrorsListExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-create',
        Component: (0, _lazy_endpoint_policy_create_extension.getLazyEndpointPolicyCreateExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-create-multi-step',
        Component: _lazy_endpoint_policy_create_multi_step_extension.LazyEndpointPolicyCreateMultiStepExtension
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-detail-custom',
        Component: (0, _lazy_endpoint_package_custom_extension.getLazyEndpointPackageCustomExtension)(registerOptions)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-detail-assets',
        Component: _lazy_endpoint_custom_assets_extension.LazyEndpointCustomAssetsExtension
      });
      registerExtension({
        package: 'endpoint',
        view: 'endpoint-agent-tamper-protection',
        Component: (0, _lazy_endpoint_agent_tamper_protection_extension.getLazyEndpointAgentTamperProtectionExtension)(registerOptions)
      });
      registerExtension({
        package: 'cribl',
        view: 'package-policy-replace-define-step',
        Component: _lazy_custom_cribl_extension.LazyCustomCriblExtension
      });
    }

    // Not using await to prevent blocking start execution
    this.registerAppLinks(core, plugins);
    return this.contract.getStartContract(core);
  }
  stop() {
    this.services.stop();
  }
  async createSubPlugins() {
    if (!this._subPlugins) {
      const {
        subPluginClasses
      } = await this.lazySubPlugins();
      this._subPlugins = {
        alerts: new subPluginClasses.Detections(),
        attackDiscovery: new subPluginClasses.AttackDiscovery(),
        rules: new subPluginClasses.Rules(),
        exceptions: new subPluginClasses.Exceptions(),
        cases: new subPluginClasses.Cases(),
        dashboards: new subPluginClasses.Dashboards(),
        explore: new subPluginClasses.Explore(),
        kubernetes: new subPluginClasses.Kubernetes(),
        overview: new subPluginClasses.Overview(),
        timelines: new subPluginClasses.Timelines(),
        management: new subPluginClasses.Management(),
        cloudDefend: new subPluginClasses.CloudDefend(),
        cloudSecurityPosture: new subPluginClasses.CloudSecurityPosture(),
        threatIntelligence: new subPluginClasses.ThreatIntelligence(),
        entityAnalytics: new subPluginClasses.EntityAnalytics(),
        assets: new subPluginClasses.Assets(),
        investigations: new subPluginClasses.Investigations(),
        machineLearning: new subPluginClasses.MachineLearning()
      };
    }
    return this._subPlugins;
  }

  /**
   * All started subPlugins.
   */
  async startSubPlugins(storage, core, plugins) {
    const subPlugins = await this.createSubPlugins();
    return {
      alerts: subPlugins.alerts.start(storage),
      attackDiscovery: subPlugins.attackDiscovery.start(),
      cases: subPlugins.cases.start(),
      cloudDefend: subPlugins.cloudDefend.start(),
      cloudSecurityPosture: subPlugins.cloudSecurityPosture.start(),
      dashboards: subPlugins.dashboards.start(),
      exceptions: subPlugins.exceptions.start(storage),
      explore: subPlugins.explore.start(storage),
      kubernetes: subPlugins.kubernetes.start(),
      management: subPlugins.management.start(core, plugins),
      overview: subPlugins.overview.start(),
      rules: subPlugins.rules.start(storage),
      threatIntelligence: subPlugins.threatIntelligence.start(),
      timelines: subPlugins.timelines.start(),
      entityAnalytics: subPlugins.entityAnalytics.start(this.experimentalFeatures.riskScoringRoutesEnabled),
      assets: subPlugins.assets.start(),
      investigations: subPlugins.investigations.start(),
      machineLearning: subPlugins.machineLearning.start()
    };
  }

  /**
   * Lazily instantiate a `SecurityAppStore`. We lazily instantiate this because it requests large dynamic imports. We instantiate it once because each subPlugin needs to share the same reference.
   */
  async store(coreStart, startPlugins, subPlugins) {
    if (!this._store) {
      const {
        createStoreFactory
      } = await this.lazyApplicationDependencies();
      this._store = await createStoreFactory(coreStart, startPlugins, subPlugins, this.storage, this.experimentalFeatures);
    }
    if (startPlugins.timelines) {
      startPlugins.timelines.setTimelineEmbeddedStore(this._store);
    }
    return this._store;
  }
  async registerActions(store, history, services) {
    if (!this._actionsRegistered) {
      const {
        registerActions
      } = await this.lazyActions();
      registerActions(store, history, services);
      this._actionsRegistered = true;
    }
  }

  /**
   * Registers the alerts tables configurations.
   */
  async registerAlertsTableConfiguration(triggersActionsUi) {
    if (!this._alertsTableRegistered) {
      const {
        registerAlertsTableConfiguration
      } = await this.lazyRegisterAlertsTableConfiguration();
      registerAlertsTableConfiguration(triggersActionsUi.alertsTableConfigurationRegistry, this.storage);
      this._alertsTableRegistered = true;
    }
  }

  /**
   * Registers deepLinks and appUpdater for appLinks using license.
   */
  async registerAppLinks(core, plugins) {
    const {
      appLinks: initialAppLinks,
      getFilteredLinks,
      solutionAppLinksSwitcher
    } = await this.lazyApplicationLinks();
    const {
      license$
    } = plugins.licensing;
    const {
      upsellingService,
      isSolutionNavigationEnabled$
    } = this.contract;
    (0, _deep_links.registerDeepLinksUpdater)(this.appUpdater$, isSolutionNavigationEnabled$);
    const appLinks$ = new _rxjs.Subject();
    appLinks$.next(initialAppLinks);
    appLinks$.pipe((0, _rxjs.combineLatestWith)(license$, isSolutionNavigationEnabled$)).subscribe(([appLinks, license, isSolutionNavigationEnabled]) => {
      const links = isSolutionNavigationEnabled ? solutionAppLinksSwitcher(appLinks) : appLinks;
      const linksPermissions = {
        experimentalFeatures: this.experimentalFeatures,
        upselling: upsellingService,
        capabilities: core.application.capabilities,
        uiSettingsClient: core.uiSettings,
        ...(license.type != null && {
          license
        })
      };
      (0, _links.updateAppLinks)(links, linksPermissions);
    });
    const filteredLinks = await getFilteredLinks(core, plugins);
    appLinks$.next(filteredLinks);
  }

  // Lazy loaded dependencies

  lazyHelpersForRoutes() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyHelpersForRoutes" */
    './helpers')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazyApplicationDependencies() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_application_dependencies" */
    './lazy_application_dependencies')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazySubPlugins() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_sub_plugins" */
    './lazy_sub_plugins')));
  }
  lazyRegisterAlertsTableConfiguration() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_register_alerts_table_configuration" */
    './common/lib/triggers_actions_ui/register_alerts_table_configuration')));
  }
  lazyApplicationLinks() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_app_links" */
    './app_links')));
  }
  lazyActions() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "actions" */
    './actions')));
  }
  lazyAssistantSettingsManagement() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_assistant_settings_management" */
    './lazy_assistant_settings_management')));
  }
}
exports.Plugin = Plugin;