"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sidebar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _constants = require("../../../../common/constants");
var _filters = require("../recent_timelines/filters");
var _recent_timelines = require("../recent_timelines");
var _news_feed = require("../../../common/components/news_feed");
var _sidebar_header = require("../../../common/components/sidebar_header");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _recent_cases = require("../recent_cases");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SidebarSpacerComponent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl"
}));
SidebarSpacerComponent.displayName = 'SidebarSpacerComponent';
const Sidebar = exports.Sidebar = /*#__PURE__*/_react.default.memo(({
  recentTimelinesFilterBy,
  setRecentTimelinesFilterBy
}) => {
  const {
    cases
  } = (0, _kibana_react.useKibana)().services;
  const recentTimelinesFilters = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_filters.Filters, {
    filterBy: recentTimelinesFilterBy,
    setFilterBy: setRecentTimelinesFilterBy
  }), [recentTimelinesFilterBy, setRecentTimelinesFilterBy]);

  // only render the recently created cases view if the user has at least read permissions
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const hasCasesReadPermissions = userCasesPermissions.read;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "l"
  }, hasCasesReadPermissions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_recent_cases.RecentCases, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
    title: i18n.RECENT_TIMELINES
  }, recentTimelinesFilters), /*#__PURE__*/_react.default.createElement(_recent_timelines.StatefulRecentTimelines, {
    filterBy: recentTimelinesFilterBy
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_news_feed.StatefulNewsFeed, {
    enableNewsFeedSetting: _constants.ENABLE_NEWS_FEED_SETTING,
    newsFeedSetting: _constants.NEWS_FEED_URL_SETTING
  })));
});
Sidebar.displayName = 'Sidebar';