"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverviewHostStats = exports.OverviewHostStats = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _stat_value = require("../stat_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOverviewHostStats = data => {
  var _data$auditbeatAuditd, _data$auditbeatFIM, _data$auditbeatLogin, _data$auditbeatPackag, _data$auditbeatProces, _data$auditbeatUser, _data$endgameDns, _data$endgameFile, _data$endgameImageLoa, _data$endgameNetwork, _data$endgameProcess, _data$endgameRegistry, _data$endgameSecurity, _data$filebeatSystemM, _data$winlogbeatSecur, _data$winlogbeatMWSys;
  return [{
    count: (_data$auditbeatAuditd = data.auditbeatAuditd) !== null && _data$auditbeatAuditd !== void 0 ? _data$auditbeatAuditd : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatAuditTitle",
      defaultMessage: "Audit"
    }),
    id: 'auditbeatAuditd'
  }, {
    count: (_data$auditbeatFIM = data.auditbeatFIM) !== null && _data$auditbeatFIM !== void 0 ? _data$auditbeatFIM : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatFimTitle",
      defaultMessage: "File Integrity Module"
    }),
    id: 'auditbeatFIM'
  }, {
    count: (_data$auditbeatLogin = data.auditbeatLogin) !== null && _data$auditbeatLogin !== void 0 ? _data$auditbeatLogin : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatLoginTitle",
      defaultMessage: "Login"
    }),
    id: 'auditbeatLogin'
  }, {
    count: (_data$auditbeatPackag = data.auditbeatPackage) !== null && _data$auditbeatPackag !== void 0 ? _data$auditbeatPackag : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatPackageTitle",
      defaultMessage: "Package"
    }),
    id: 'auditbeatPackage'
  }, {
    count: (_data$auditbeatProces = data.auditbeatProcess) !== null && _data$auditbeatProces !== void 0 ? _data$auditbeatProces : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatProcessTitle",
      defaultMessage: "Process"
    }),
    id: 'auditbeatProcess'
  }, {
    count: (_data$auditbeatUser = data.auditbeatUser) !== null && _data$auditbeatUser !== void 0 ? _data$auditbeatUser : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatUserTitle",
      defaultMessage: "User"
    }),
    id: 'auditbeatUser'
  }, {
    count: (_data$endgameDns = data.endgameDns) !== null && _data$endgameDns !== void 0 ? _data$endgameDns : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameDnsTitle",
      defaultMessage: "DNS"
    }),
    id: 'endgameDns'
  }, {
    count: (_data$endgameFile = data.endgameFile) !== null && _data$endgameFile !== void 0 ? _data$endgameFile : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameFileTitle",
      defaultMessage: "File"
    }),
    id: 'endgameFile'
  }, {
    count: (_data$endgameImageLoa = data.endgameImageLoad) !== null && _data$endgameImageLoa !== void 0 ? _data$endgameImageLoa : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameImageLoadTitle",
      defaultMessage: "Image Load"
    }),
    id: 'endgameImageLoad'
  }, {
    count: (_data$endgameNetwork = data.endgameNetwork) !== null && _data$endgameNetwork !== void 0 ? _data$endgameNetwork : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameNetworkTitle",
      defaultMessage: "Network"
    }),
    id: 'endgameNetwork'
  }, {
    count: (_data$endgameProcess = data.endgameProcess) !== null && _data$endgameProcess !== void 0 ? _data$endgameProcess : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameProcessTitle",
      defaultMessage: "Process"
    }),
    id: 'endgameProcess'
  }, {
    count: (_data$endgameRegistry = data.endgameRegistry) !== null && _data$endgameRegistry !== void 0 ? _data$endgameRegistry : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameRegistryTitle",
      defaultMessage: "Registry"
    }),
    id: 'endgameRegistry'
  }, {
    count: (_data$endgameSecurity = data.endgameSecurity) !== null && _data$endgameSecurity !== void 0 ? _data$endgameSecurity : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameSecurityTitle",
      defaultMessage: "Security"
    }),
    id: 'endgameSecurity'
  }, {
    count: (_data$filebeatSystemM = data.filebeatSystemModule) !== null && _data$filebeatSystemM !== void 0 ? _data$filebeatSystemM : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatSystemModuleTitle",
      defaultMessage: "System Module"
    }),
    id: 'filebeatSystemModule'
  }, {
    count: (_data$winlogbeatSecur = data.winlogbeatSecurity) !== null && _data$winlogbeatSecur !== void 0 ? _data$winlogbeatSecur : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.winlogbeatSecurityTitle",
      defaultMessage: "Security"
    }),
    id: 'winlogbeatSecurity'
  }, {
    count: (_data$winlogbeatMWSys = data.winlogbeatMWSysmonOperational) !== null && _data$winlogbeatMWSys !== void 0 ? _data$winlogbeatMWSys : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.winlogbeatMWSysmonOperational",
      defaultMessage: "Microsoft-Windows-Sysmon/Operational"
    }),
    id: 'winlogbeatMWSysmonOperational'
  }];
};
exports.getOverviewHostStats = getOverviewHostStats;
const HostStatsContainer = _styledComponents.default.div`
  .accordion-button {
    width: 100%;
  }
`;
const hostStatGroups = [{
  groupId: 'auditbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupAuditbeat",
    defaultMessage: "Auditbeat"
  }),
  statIds: ['auditbeatAuditd', 'auditbeatFIM', 'auditbeatLogin', 'auditbeatPackage', 'auditbeatProcess', 'auditbeatUser']
}, {
  groupId: 'endgame',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupElasticEndpointSecurity",
    defaultMessage: "Endpoint Security"
  }),
  statIds: ['endgameDns', 'endgameFile', 'endgameImageLoad', 'endgameNetwork', 'endgameProcess', 'endgameRegistry', 'endgameSecurity']
}, {
  groupId: 'filebeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupFilebeat",
    defaultMessage: "Filebeat"
  }),
  statIds: ['filebeatSystemModule']
}, {
  groupId: 'winlogbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupWinlogbeat",
    defaultMessage: "Winlogbeat"
  }),
  statIds: ['winlogbeatSecurity', 'winlogbeatMWSysmonOperational']
}];
const MoveItLeftTitle = _styledComponents.default.div`
  margin-left: 24px;
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
    max-width: 40px;
  }
`;
const MoveItLeft = _styledComponents.default.div`
  margin-left: 24px;
`;
const NoMarginTopFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  @media only screen and (max-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
    margin-top: -10px !important;
  }
`;
const AccordionContent = _styledComponents.default.div`
  padding-top: 8px;
`;
const OverviewHostStatsComponent = ({
  data,
  loading
}) => {
  const allHostStats = getOverviewHostStats(data);
  const allHostStatsCount = allHostStats.reduce((total, stat) => total + stat.count, 0);
  return /*#__PURE__*/_react.default.createElement(HostStatsContainer, {
    "data-test-subj": "overview-hosts-stats"
  }, hostStatGroups.map((statGroup, i) => {
    const statsForGroup = allHostStats.filter(s => statGroup.statIds.includes(s.id));
    const statsForGroupCount = statsForGroup.reduce((total, stat) => total + stat.count, 0);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: statGroup.groupId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `host-stat-accordion-group${statGroup.groupId}`,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, statGroup.name)), /*#__PURE__*/_react.default.createElement(NoMarginTopFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
        count: statsForGroupCount,
        isGroupStat: true,
        isLoading: loading,
        max: allHostStatsCount
      }))),
      buttonContentClassName: "accordion-button"
    }, /*#__PURE__*/_react.default.createElement(AccordionContent, null, statsForGroup.map(stat => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: stat.id,
      gutterSize: "s",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(MoveItLeftTitle, null, stat.title))), /*#__PURE__*/_react.default.createElement(NoMarginTopFlexItem, {
      "data-test-subj": `host-stat-${stat.id}`,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(MoveItLeft, null, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
      count: stat.count,
      isGroupStat: false,
      isLoading: loading,
      max: statsForGroupCount
    }))))))));
  }));
};
const OverviewHostStats = exports.OverviewHostStats = /*#__PURE__*/_react.default.memo(OverviewHostStatsComponent);