"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesByStatus = void 0;
var _react = require("react");
var _uuid = require("uuid");
var _constants = require("../../../../../common/constants");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesByStatus = ({
  skip = false
}) => {
  var _casesCounts$countClo, _casesCounts$countInP, _casesCounts$countOpe, _casesCounts$countClo2, _casesCounts$countInP2, _casesCounts$countOpe2;
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const {
    to,
    from,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `useCaseItems-${(0, _uuid.v4)()}`, []);
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [casesCounts, setCasesCounts] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const fetchCases = async () => {
      try {
        const casesResponse = await cases.api.cases.getCasesStatus({
          from,
          to,
          owner: _constants.APP_ID
        }, abortCtrl.signal);
        if (isSubscribed) {
          setCasesCounts(casesResponse);
        }
      } catch (error) {
        if (isSubscribed) {
          setCasesCounts(null);
        }
      }
      if (isSubscribed) {
        setIsLoading(false);
        setUpdatedAt(Date.now());
      }
    };
    if (!skip) {
      fetchCases();
      setQuery({
        id: uniqueQueryId,
        inspect: null,
        loading: false,
        refetch: fetchCases
      });
    }
    if (skip) {
      setIsLoading(false);
      isSubscribed = false;
      abortCtrl.abort();
    }
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
      deleteQuery({
        id: uniqueQueryId
      });
    };
  }, [cases.api.cases, from, skip, to, setQuery, deleteQuery, uniqueQueryId]);
  return {
    closed: (_casesCounts$countClo = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.countClosedCases) !== null && _casesCounts$countClo !== void 0 ? _casesCounts$countClo : 0,
    inProgress: (_casesCounts$countInP = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.countInProgressCases) !== null && _casesCounts$countInP !== void 0 ? _casesCounts$countInP : 0,
    isLoading,
    open: (_casesCounts$countOpe = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.countOpenCases) !== null && _casesCounts$countOpe !== void 0 ? _casesCounts$countOpe : 0,
    totalCounts: ((_casesCounts$countClo2 = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.countClosedCases) !== null && _casesCounts$countClo2 !== void 0 ? _casesCounts$countClo2 : 0) + ((_casesCounts$countInP2 = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.countInProgressCases) !== null && _casesCounts$countInP2 !== void 0 ? _casesCounts$countInP2 : 0) + ((_casesCounts$countOpe2 = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.countOpenCases) !== null && _casesCounts$countOpe2 !== void 0 ? _casesCounts$countOpe2 : 0),
    updatedAt
  };
};
exports.useCasesByStatus = useCasesByStatus;