"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numberFormatter = exports.barchartConfigs = exports.CasesByStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _barchart = require("../../../../common/components/charts/barchart");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _header_section = require("../../../../common/components/header_section");
var _translations = require("../translations");
var _links = require("../../../../common/components/links");
var _use_cases_by_status = require("./use_cases_by_status");
var _constants = require("../../../../../common/constants");
var _link_to = require("../../../../common/components/link_to");
var _helpers = require("../../../../common/components/link_to/helpers");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASES_BY_STATUS_ID = 'casesByStatus';
const numberFormatter = value => value.toLocaleString();
exports.numberFormatter = numberFormatter;
const barchartConfigs = exports.barchartConfigs = {
  series: {
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    stackAccessors: ['g'],
    barSeriesStyle: {
      rect: {
        widthPixel: 22,
        opacity: 1
      }
    }
  },
  axis: {
    xTickFormatter: numberFormatter,
    left: {
      style: {
        tickLine: {
          size: 0
        },
        tickLabel: {
          padding: 16,
          fontSize: 14
        }
      }
    },
    bottom: {
      style: {
        tickLine: {
          size: 0
        },
        tickLabel: {
          padding: 16,
          fontSize: 10.5
        }
      },
      labelFormat: d => (0, _numeral.default)(d).format('0')
    }
  },
  settings: {
    rotation: 90
  },
  customHeight: 146
};
const barColors = {
  empty: 'rgba(105, 112, 125, 0.1)',
  open: '#79aad9',
  'in-progress': '#f1d86f',
  closed: '#d3dae6'
};
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-items: center;
  width: 70%;
`;
const Wrapper = _styledComponents.default.div`
  width: 100%;
`;
const CasesByStatusComponent = () => {
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(CASES_BY_STATUS_ID);
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const {
    search
  } = (0, _link_to.useFormatUrl)(_constants.SecurityPageName.case);
  const caseUrl = getAppUrl({
    deepLinkId: _constants.SecurityPageName.case,
    path: (0, _helpers.appendSearch)(search)
  });
  const goToCases = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateTo({
      url: caseUrl
    });
  }, [caseUrl, navigateTo]);
  const {
    closed,
    inProgress,
    isLoading,
    open,
    totalCounts,
    updatedAt
  } = (0, _use_cases_by_status.useCasesByStatus)({
    skip: !toggleStatus
  });
  const chartData = (0, _react.useMemo)(() => [{
    key: 'open',
    value: [{
      y: open,
      x: _translations.STATUS_OPEN,
      g: _translations.STATUS_OPEN
    }],
    color: barColors.open
  }, {
    key: 'in-progress',
    value: [{
      y: inProgress,
      x: _translations.STATUS_IN_PROGRESS,
      g: _translations.STATUS_IN_PROGRESS
    }],
    color: barColors['in-progress']
  }, {
    key: 'closed',
    value: [{
      y: closed,
      x: _translations.STATUS_CLOSED,
      g: _translations.STATUS_CLOSED
    }],
    color: barColors.closed
  }], [closed, inProgress, open]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: CASES_BY_STATUS_ID,
    title: _translations.CASES_BY_STATUS_SECTION_TITLE,
    titleSize: "s",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading
    }),
    showInspectButton: false,
    tooltip: _translations.CASES_BY_STATUS_SECTION_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    href: caseUrl,
    onClick: goToCases
  }, _translations.VIEW_CASES)))), !isLoading && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, totalCounts !== 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textCenter",
    size: "s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: totalCounts
  })), ' ', /*#__PURE__*/_react.default.createElement("span", null, " ", (0, _translations.CASES)(totalCounts))))), /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Wrapper, {
    "data-test-subj": "chart-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_barchart.BarChart, {
    configs: barchartConfigs,
    barChart: chartData
  })))));
};
const CasesByStatus = exports.CasesByStatus = /*#__PURE__*/_react.default.memo(CasesByStatusComponent);