"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsByStatusVisualizationData = exports.openAlertsVisualizationId = exports.closedAlertsVisualizationId = exports.acknowledgedAlertsVisualizationId = void 0;
var _use_visualization_response = require("../../../../common/components/visualization_actions/use_visualization_response");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openAlertsVisualizationId = exports.openAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-open`;
const acknowledgedAlertsVisualizationId = exports.acknowledgedAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}- acknowledged`;
const closedAlertsVisualizationId = exports.closedAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-closed`;
const useAlertsByStatusVisualizationData = () => {
  var _ref;
  const {
    responses: openAlertsResponses
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: openAlertsVisualizationId
  });
  const {
    responses: acknowledgedAlertsResponses
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: acknowledgedAlertsVisualizationId
  });
  const {
    responses: closedAlertsResponses
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: closedAlertsVisualizationId
  });
  const visualizationOpenAlertsData = openAlertsResponses != null ? openAlertsResponses[0].hits.total : 0;
  const visualizationAcknowledgedAlertsData = acknowledgedAlertsResponses != null ? acknowledgedAlertsResponses[0].hits.total : 0;
  const visualizationClosedAlertsData = closedAlertsResponses != null ? closedAlertsResponses[0].hits.total : 0;
  const visualizationTotalAlertsData = (_ref = visualizationOpenAlertsData + visualizationAcknowledgedAlertsData + visualizationClosedAlertsData) !== null && _ref !== void 0 ? _ref : 0;
  return {
    open: visualizationOpenAlertsData,
    acknowledged: visualizationAcknowledgedAlertsData,
    closed: visualizationClosedAlertsData,
    total: visualizationTotalAlertsData
  };
};
exports.useAlertsByStatusVisualizationData = useAlertsByStatusVisualizationData;