"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendPutPackagePolicy = exports.sendGetPackagePolicy = exports.sendGetFleetAgentStatusForPolicy = exports.sendGetEndpointSecurityPackage = exports.sendBulkGetPackagePolicies = exports.INGEST_API_PACKAGE_POLICIES = exports.INGEST_API_FLEET_AGENTS = exports.INGEST_API_EPM_PACKAGES = exports.INGEST_API_AGENT_POLICIES = void 0;
var _common = require("@kbn/fleet-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INGEST_API_ROOT = `/api/fleet`;
const INGEST_API_PACKAGE_POLICIES = exports.INGEST_API_PACKAGE_POLICIES = `${INGEST_API_ROOT}/package_policies`;
const INGEST_API_AGENT_POLICIES = exports.INGEST_API_AGENT_POLICIES = `${INGEST_API_ROOT}/agent_policies`;
const INGEST_API_FLEET_AGENT_STATUS = `${INGEST_API_ROOT}/agent_status`;
const INGEST_API_FLEET_AGENTS = exports.INGEST_API_FLEET_AGENTS = `${INGEST_API_ROOT}/agents`;
const INGEST_API_EPM_PACKAGES = exports.INGEST_API_EPM_PACKAGES = `${INGEST_API_ROOT}/epm/packages`;

/**
 * Retrieves a single package policy based on ID from ingest
 * @param http
 * @param packagePolicyId
 * @param options
 */
const sendGetPackagePolicy = (http, packagePolicyId, options) => {
  return http.get(`${INGEST_API_PACKAGE_POLICIES}/${packagePolicyId}`, {
    ...options,
    version: _common.API_VERSIONS.public.v1
  });
};

/**
 * Retrieves multiple package policies by ids
 * @param http
 * @param packagePolicyIds
 * @param options
 */
exports.sendGetPackagePolicy = sendGetPackagePolicy;
const sendBulkGetPackagePolicies = (http, packagePolicyIds, options) => {
  return http.post(`${INGEST_API_PACKAGE_POLICIES}/_bulk_get`, {
    ...options,
    version: _common.API_VERSIONS.public.v1,
    body: JSON.stringify({
      ids: packagePolicyIds,
      ignoreMissing: true
    })
  });
};

/**
 * Updates a package policy
 *
 * @param http
 * @param packagePolicyId
 * @param packagePolicy
 * @param options
 */
exports.sendBulkGetPackagePolicies = sendBulkGetPackagePolicies;
const sendPutPackagePolicy = (http, packagePolicyId, packagePolicy, options = {}) => {
  return http.put(`${INGEST_API_PACKAGE_POLICIES}/${packagePolicyId}`, {
    ...options,
    version: _common.API_VERSIONS.public.v1,
    body: JSON.stringify(packagePolicy)
  });
};

/**
 * Get a status summary for all Agents that are currently assigned to a given agent policy
 *
 * @param http
 * @param policyId
 * @param options
 */
exports.sendPutPackagePolicy = sendPutPackagePolicy;
const sendGetFleetAgentStatusForPolicy = (http, policyId, options = {}) => {
  return http.get(INGEST_API_FLEET_AGENT_STATUS, {
    ...options,
    version: _common.API_VERSIONS.public.v1,
    query: {
      policyId
    }
  });
};

/**
 * Get Endpoint Security Package information
 */
exports.sendGetFleetAgentStatusForPolicy = sendGetFleetAgentStatusForPolicy;
const sendGetEndpointSecurityPackage = async http => {
  const path = _common.epmRouteService.getInfoPath('endpoint');
  const endpointPackageResponse = await http.get(path, {
    version: _common.API_VERSIONS.public.v1
  });
  const endpointPackageInfo = endpointPackageResponse.item;
  if (!endpointPackageInfo) {
    throw new Error('Endpoint package was not found.');
  }
  return endpointPackageInfo;
};
exports.sendGetEndpointSecurityPackage = sendGetEndpointSecurityPackage;