"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SupportedVersionForProtectionNotice = exports.NotifyUserOption = exports.NOTIFY_USER_SECTION_TITLE = exports.NOTIFY_USER_CHECKBOX_LABEL = exports.CUSTOMIZE_NOTIFICATION_MESSAGE_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _protection_notice_supported_endpoint_version = require("../protection_notice_supported_endpoint_version");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _empty_value = require("../../../../../../common/components/empty_value");
var _use_license = require("../../../../../../common/hooks/use_license");
var _setting_card = require("./setting_card");
var _types = require("../../../../../../../common/endpoint/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NOTIFY_USER_SECTION_TITLE = exports.NOTIFY_USER_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.userNotification', {
  defaultMessage: 'User notification'
});
const NOTIFY_USER_CHECKBOX_LABEL = exports.NOTIFY_USER_CHECKBOX_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.notifyUser', {
  defaultMessage: 'Notify user'
});
const NOTIFICATION_MESSAGE_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.notificationMessage', {
  defaultMessage: 'Notification message'
});
const CUSTOMIZE_NOTIFICATION_MESSAGE_LABEL = exports.CUSTOMIZE_NOTIFICATION_MESSAGE_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.customizeUserNotification', {
  defaultMessage: 'Customize notification message'
});
const NotifyUserOption = exports.NotifyUserOption = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode,
  protection,
  osList,
  'data-test-subj': dataTestSubj
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isEditMode = mode === 'edit';
  const selected = policy.windows[protection].mode;
  const userNotificationSelected = policy.windows.popup[protection].enabled;
  const userNotificationMessage = policy.windows.popup[protection].message;
  const handleUserNotificationCheckbox = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    for (const os of osList) {
      if (os === 'windows') {
        newPayload[os].popup[protection].enabled = event.target.checked;
      } else if (os === 'mac') {
        newPayload[os].popup[protection].enabled = event.target.checked;
      } else if (os === 'linux') {
        newPayload[os].popup[protection].enabled = event.target.checked;
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange, osList, protection]);
  const handleCustomUserNotification = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    for (const os of osList) {
      if (os === 'windows') {
        newPayload[os].popup[protection].message = event.target.value;
      } else if (os === 'mac') {
        newPayload[os].popup[protection].message = event.target.value;
      } else if (os === 'linux') {
        newPayload[os].popup[protection].message = event.target.value;
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange, osList, protection]);
  const tooltipProtectionText = (0, _react.useCallback)(protectionType => {
    if (protectionType === 'memory_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.memoryProtectionTooltip', {
        defaultMessage: 'memory threat'
      });
    } else if (protectionType === 'behavior_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.behaviorProtectionTooltip', {
        defaultMessage: 'malicious behavior'
      });
    } else {
      return protectionType;
    }
  }, []);
  const tooltipBracketText = (0, _react.useCallback)(protectionType => {
    if (protectionType === 'memory_protection' || protection === 'behavior_protection') {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.rule', {
        defaultMessage: 'rule'
      });
    } else {
      return _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.filename', {
        defaultMessage: 'filename'
      });
    }
  }, [protection]);
  if (!isPlatinumPlus) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, {
    "data-test-subj": getTestId('title')
  }, NOTIFY_USER_SECTION_TITLE), /*#__PURE__*/_react.default.createElement(SupportedVersionForProtectionNotice, {
    protection: protection,
    "data-test-subj": getTestId('supportedVersion')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": getTestId('checkbox'),
    id: `${protection}UserNotificationCheckbox}`,
    onChange: handleUserNotificationCheckbox,
    checked: userNotificationSelected,
    disabled: !isEditMode || selected === _types.ProtectionModes.off,
    label: NOTIFY_USER_CHECKBOX_LABEL
  }), userNotificationSelected && (isEditMode ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('customMessageTitle')
  }, /*#__PURE__*/_react.default.createElement("h4", null, CUSTOMIZE_NOTIFICATION_MESSAGE_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    "data-test-subj": getTestId('tooltipInfo'),
    anchorProps: {
      'data-test-subj': getTestId('tooltipIcon')
    },
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.notifyUserTooltip.a",
      defaultMessage: "Selecting the user notification option will display a notification to the host user when { protectionName } is prevented or detected.",
      values: {
        protectionName: tooltipProtectionText(protection)
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.notifyUserTooltip.c",
      defaultMessage: " The user notification can be customized in the text box below. Bracketed tags can be used to dynamically populate the applicable action (such as prevented or detected) and the { bracketText }.",
      values: {
        bracketText: tooltipBracketText(protection)
      }
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.userNotification.placeholder', {
      defaultMessage: 'Input your custom notification message'
    }),
    value: userNotificationMessage,
    onChange: handleCustomUserNotification,
    fullWidth: true,
    disabled: !isEditMode,
    "data-test-subj": getTestId('customMessage')
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, NOTIFICATION_MESSAGE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userNotificationMessage || (0, _empty_value.getEmptyValue)()))));
});
NotifyUserOption.displayName = 'NotifyUserOption';
const SupportedVersionForProtectionNotice = exports.SupportedVersionForProtectionNotice = /*#__PURE__*/_react.default.memo(({
  protection,
  'data-test-subj': dataTestSubj
}) => {
  const version = (0, _react.useMemo)(() => {
    return _protection_notice_supported_endpoint_version.PROTECTION_NOTICE_SUPPORTED_ENDPOINT_VERSION[protection];
  }, [protection]);
  if (!version) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement("i", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.supportedVersion",
    defaultMessage: "Agent version {version}",
    values: {
      version
    }
  })));
});
SupportedVersionForProtectionNotice.displayName = 'SupportedVersionForProtectionNotice';