"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventCollectionCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _styledComponents = require("styled-components");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _empty_value = require("../../../../../../common/components/empty_value");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _setting_card = require("./setting_card");
var _types = require("../../../../../../../common/endpoint/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapOperatingSystemToPolicyOsKey = {
  [_securitysolutionUtils.OperatingSystem.WINDOWS]: _types.PolicyOperatingSystem.windows,
  [_securitysolutionUtils.OperatingSystem.LINUX]: _types.PolicyOperatingSystem.linux,
  [_securitysolutionUtils.OperatingSystem.MAC]: _types.PolicyOperatingSystem.mac
};

// eslint-disable-next-line @typescript-eslint/no-explicit-any

const EventCollectionCard = exports.EventCollectionCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  os,
  options,
  selection,
  supplementalOptions,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isEditMode = mode === 'edit';
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  const totalOptions = options.length;
  const policyOs = mapOperatingSystemToPolicyOsKey[os];
  const selectedCount = (0, _react.useMemo)(() => {
    const supplementalSelectionFields = supplementalOptions ? supplementalOptions.map(value => value.protectionField) : [];
    return Object.entries(selection).filter(([key, value]) => !supplementalSelectionFields.includes(key) ? value : false).length;
  }, [selection, supplementalOptions]);
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.eventCollection', {
      defaultMessage: 'Event collection'
    }),
    supportedOss: [os],
    mode: mode,
    selected: selectedCount > 0,
    rightCorner: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      "data-test-subj": getTestId('selectedCount')
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.eventCollectionsEnabled', {
      defaultMessage: '{selected} / {total} event collections enabled',
      values: {
        selected: selectedCount,
        total: totalOptions
      }
    })),
    dataTestSubj: getTestId()
  }, /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, null, _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.eventingEvents', {
    defaultMessage: 'Events'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('options')
  }, options.map(({
    name,
    protectionField
  }) => {
    const keyPath = `${policyOs}.events.${String(protectionField)}`;
    return /*#__PURE__*/_react.default.createElement(EventCheckbox, {
      label: name,
      key: keyPath,
      keyPath: keyPath,
      policy: policy,
      onChange: onChange,
      disabled: !isEditMode,
      "data-test-subj": getTestId(protectionField)
    });
  }), selectedCount === 0 && !isEditMode && /*#__PURE__*/_react.default.createElement("div", null, (0, _empty_value.getEmptyValue)())), supplementalOptions && supplementalOptions.map(({
    title,
    description,
    name,
    protectionField,
    tooltipText,
    beta,
    indented,
    isDisabled
  }) => {
    const keyPath = `${policyOs}.events.${String(protectionField)}`;
    const fieldString = protectionField;
    const isCheckboxDisabled = !isEditMode || (isDisabled ? isDisabled(policy) : false);
    return /*#__PURE__*/_react.default.createElement("div", {
      key: String(protectionField),
      style: indented ? {
        paddingLeft: theme.eui.euiSizeL
      } : {},
      "data-test-subj": getTestId(`${fieldString}Container`)
    }, title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, {
      "data-test-subj": getTestId(`${fieldString}Title`)
    }, title)), description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      "data-test-subj": getTestId(`${fieldString}Description`)
    }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(EventCheckbox, {
      label: name,
      key: keyPath,
      keyPath: keyPath,
      policy: policy,
      onChange: onChange,
      disabled: isCheckboxDisabled,
      "data-test-subj": getTestId(fieldString)
    })), tooltipText && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: tooltipText,
      anchorProps: {
        'data-test-subj': getTestId(`${fieldString}TooltipIcon`)
      }
    })), beta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "beta",
      size: "s",
      "data-test-subj": getTestId(`${fieldString}Badge`)
    }))));
  }));
});
EventCollectionCard.displayName = 'EventCollectionCard';
const EventCheckbox = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  label,
  keyPath,
  disabled,
  'data-test-subj': dataTestSubj
}) => {
  const isChecked = (0, _lodash.get)(policy, keyPath);
  const checkboxOnChangeHandler = (0, _react.useCallback)(ev => {
    const updatedPolicy = (0, _lodash.cloneDeep)(policy);
    (0, _lodash.set)(updatedPolicy, keyPath, ev.target.checked);
    onChange({
      isValid: true,
      updatedPolicy
    });
  }, [keyPath, onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    key: keyPath,
    id: keyPath,
    label: label,
    "data-test-subj": dataTestSubj,
    checked: isChecked,
    onChange: checkboxOnChangeHandler,
    disabled: disabled
  });
});
EventCheckbox.displayName = 'EventCheckbox';