"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventFiltersFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rxjs = require("rxjs");
var _use_with_artifact_submit_data = require("../../../../components/artifact_list_page/hooks/use_with_artifact_submit_data");
var _artifact_confirm_modal = require("../../../../components/artifact_list_page/components/artifact_confirm_modal");
var _form = require("./form");
var _utils = require("../utils");
var _kibana = require("../../../../../common/lib/kibana");
var _hooks = require("../../../../services/policies/hooks");
var _translations = require("../../../../common/translations");
var _api_client = require("../../service/api_client");
var _translations2 = require("../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventFiltersFlyout = exports.EventFiltersFlyout = /*#__PURE__*/(0, _react.memo)(({
  onCancel: onClose,
  data,
  ...flyoutProps
}) => {
  var _policiesRequest$data, _policiesRequest$data2;
  const toasts = (0, _kibana.useToasts)();
  const http = (0, _kibana.useHttp)();
  const {
    isLoading: isSubmittingData,
    mutateAsync: submitData
  } = (0, _use_with_artifact_submit_data.useWithArtifactSubmitData)(_api_client.EventFiltersApiClient.getInstance(http), 'create');
  const [enrichedData, setEnrichedData] = (0, _react.useState)();
  const [isFormValid, setIsFormValid] = (0, _react.useState)(false);
  const {
    data: {
      search
    }
  } = (0, _kibana.useKibana)().services;

  // load the list of policies>
  const policiesRequest = (0, _hooks.useGetEndpointSpecificPolicies)({
    perPage: 1000,
    onError: error => {
      toasts.addWarning((0, _translations.getLoadPoliciesError)(error));
    }
  });
  const [exception, setException] = (0, _react.useState)((0, _utils.getInitialExceptionFromEvent)(data));
  const [confirmModalLabels, setConfirmModalLabels] = (0, _react.useState)();
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const policiesIsLoading = (0, _react.useMemo)(() => policiesRequest.isLoading || policiesRequest.isRefetching, [policiesRequest]);
  (0, _react.useEffect)(() => {
    const enrichEvent = async () => {
      var _data$host;
      if (!data || !data._index) return;
      const searchResponse = await (0, _rxjs.lastValueFrom)(search.search({
        params: {
          index: data._index,
          body: {
            query: {
              match: {
                _id: data._id
              }
            }
          }
        }
      }));
      setEnrichedData({
        ...data,
        host: {
          ...data.host,
          os: {
            ...((data === null || data === void 0 ? void 0 : (_data$host = data.host) === null || _data$host === void 0 ? void 0 : _data$host.os) || {}),
            name: [searchResponse.rawResponse.hits.hits[0]._source.host.os.name]
          }
        }
      });
    };
    if (data) {
      enrichEvent();
    }
    return () => {
      setException((0, _utils.getInitialExceptionFromEvent)());
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleOnClose = (0, _react.useCallback)(() => {
    if (policiesIsLoading || isSubmittingData) return;
    onClose();
  }, [isSubmittingData, policiesIsLoading, onClose]);
  const submitEventFilter = (0, _react.useCallback)(() => {
    return submitData(exception, {
      onSuccess: result => {
        toasts.addSuccess((0, _translations2.getCreationSuccessMessage)(result));
        onClose();
      },
      onError: error => {
        toasts.addError(error, (0, _translations2.getCreationErrorMessage)(error));
      }
    });
  }, [exception, onClose, submitData, toasts]);
  const handleOnSubmit = (0, _react.useCallback)(() => {
    if (confirmModalLabels) {
      setShowConfirmModal(true);
    } else {
      return submitEventFilter();
    }
  }, [confirmModalLabels, submitEventFilter]);
  const confirmButtonMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "add-exception-confirm-button",
    fill: true,
    disabled: !isFormValid || isSubmittingData || !!data && !enrichedData || policiesIsLoading,
    onClick: handleOnSubmit,
    isLoading: policiesIsLoading
  }, data ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.actions.confirm.update.withData",
    defaultMessage: "Add endpoint event filter"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.actions.confirm.create",
    defaultMessage: "Add event filter"
  })), [data, enrichedData, handleOnSubmit, isFormValid, isSubmittingData, policiesIsLoading]);

  // update flyout state with form state
  const onChange = (0, _react.useCallback)(formState => {
    if (!formState) return;
    setIsFormValid(formState.isValid);
    setException(formState.item);
    setConfirmModalLabels(formState.confirmModalLabels);
  }, []);
  const eventFiltersCreateFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'eventFiltersCreateFlyoutTitle'
  });
  const confirmModal = (0, _react.useMemo)(() => {
    if (confirmModalLabels) {
      const {
        title,
        body,
        confirmButton,
        cancelButton
      } = confirmModalLabels;
      return /*#__PURE__*/_react.default.createElement(_artifact_confirm_modal.ArtifactConfirmModal, {
        title: title,
        body: body,
        confirmButton: confirmButton,
        cancelButton: cancelButton,
        onSuccess: submitEventFilter,
        onCancel: () => setShowConfirmModal(false),
        "data-test-subj": "artifactConfirmModal"
      });
    }
  }, [confirmModalLabels, submitEventFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({
    size: "l",
    onClose: handleOnClose,
    "data-test-subj": "eventFiltersCreateFlyout",
    "aria-labelledby": eventFiltersCreateFlyoutTitleId
  }, flyoutProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: eventFiltersCreateFlyoutTitleId
  }, data ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.title.create.withData",
    defaultMessage: "Add endpoint event filter"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.subtitle.create",
    defaultMessage: "Add event filter"
  }))), data ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.subtitle.create.withData",
    defaultMessage: "Endpoint security"
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_form.EventFiltersForm, {
    allowSelectOs: !data,
    error: undefined,
    disabled: false,
    item: exception,
    mode: "create",
    onChange: onChange,
    policies: (_policiesRequest$data = policiesRequest === null || policiesRequest === void 0 ? void 0 : (_policiesRequest$data2 = policiesRequest.data) === null || _policiesRequest$data2 === void 0 ? void 0 : _policiesRequest$data2.items) !== null && _policiesRequest$data !== void 0 ? _policiesRequest$data : [],
    policiesIsLoading: policiesIsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: isSubmittingData,
    "data-test-subj": "cancelExceptionAddButton",
    onClick: handleOnClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.actions.cancel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, confirmButtonMemo))), showConfirmModal && confirmModal);
});
EventFiltersFlyout.displayName = 'EventFiltersFlyout';