"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OVERVIEW = exports.ACTIVITY_LOG = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OVERVIEW = exports.OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.endpointDetails.overview', {
  defaultMessage: 'Overview'
});
const ACTIVITY_LOG = exports.ACTIVITY_LOG = {
  tabTitle: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.responseActionsHistory', {
    defaultMessage: 'Response actions history'
  }),
  LogEntry: {
    endOfLog: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.endOfLog', {
      defaultMessage: 'Nothing more to show'
    }),
    dateRangeMessage: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.dateRangeMessage.title', {
      defaultMessage: 'Nothing to show for selected date range, please select another and try again.'
    }),
    emptyState: {
      title: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.emptyState.title', {
        defaultMessage: 'No logged actions'
      }),
      body: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.emptyState.body', {
        defaultMessage: 'No actions have been logged for this endpoint.'
      })
    },
    action: {
      isolatedAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.isolated', {
        defaultMessage: 'submitted request: Isolate host'
      }),
      unisolatedAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.unisolated', {
        defaultMessage: 'submitted request: Release host'
      }),
      failedEndpointReleaseAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.failedEndpointReleaseAction', {
        defaultMessage: 'failed to submit request: Release host'
      }),
      failedEndpointIsolateAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.failedEndpointIsolateAction', {
        defaultMessage: 'failed to submit request: Isolate host'
      })
    },
    response: {
      isolationCompletedAndSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationCompletedAndSuccessful', {
        defaultMessage: 'Host isolation request completed by Endpoint'
      }),
      isolationCompletedAndUnsuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationCompletedAndUnsuccessful', {
        defaultMessage: 'Host isolation request completed by Endpoint with errors'
      }),
      unisolationCompletedAndSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationCompletedAndSuccessful', {
        defaultMessage: 'Release request completed by Endpoint'
      }),
      unisolationCompletedAndUnsuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationCompletedAndUnsuccessful', {
        defaultMessage: 'Release request completed by Endpoint with errors'
      }),
      isolationSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationSuccessful', {
        defaultMessage: 'Host isolation request received by Endpoint'
      }),
      isolationFailed: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationFailed', {
        defaultMessage: 'Host isolation request received by Endpoint with errors'
      }),
      unisolationSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationSuccessful', {
        defaultMessage: 'Release host request received by Endpoint'
      }),
      unisolationFailed: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationFailed', {
        defaultMessage: 'Release host request received by Endpoint with errors'
      })
    }
  }
};