"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetailsContent = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _endpoint_agent_status = require("../../../../../common/components/endpoint/endpoint_agent_status");
var _utils = require("../../utils");
var _hooks = require("../hooks");
var _selectors = require("../../store/selectors");
var _host_constants = require("../host_constants");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _use_navigate_by_router_event_handler = require("../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _routing = require("../../../../common/routing");
var _endpoint_policy_link = require("../../../../components/endpoint_policy_link");
var _out_of_date = require("../components/out_of_date");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointDetailsContentStyled = _styledComponents.default.div`
  .policyLineText {
    padding-right: 5px;
  }
`;
const ColumnTitle = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, children));
};
const EndpointDetailsContent = exports.EndpointDetailsContent = /*#__PURE__*/(0, _react.memo)(({
  hostInfo,
  policyInfo
}) => {
  const queryParams = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const policyStatus = (0, _react.useMemo)(() => hostInfo.metadata.Endpoint.policy.applied.status, [hostInfo]);
  const getHostPendingActions = (0, _hooks.useEndpointSelector)(_selectors.getEndpointPendingActionsCallback);
  const missingPolicies = (0, _hooks.useEndpointSelector)(_selectors.nonExistingPolicies);
  const policyResponseRoutePath = (0, _react.useMemo)(() => {
    const {
      selected_endpoint: selectedEndpoint,
      show,
      ...currentUrlParams
    } = queryParams;
    return (0, _routing.getEndpointDetailsPath)({
      name: 'endpointPolicyResponse',
      ...currentUrlParams,
      selected_endpoint: hostInfo.metadata.agent.id
    });
  }, [hostInfo.metadata.agent.id, queryParams]);
  const policyStatusClickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(policyResponseRoutePath);
  const detailsResults = (0, _react.useMemo)(() => {
    return [{
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.os",
        defaultMessage: "OS"
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, hostInfo.metadata.host.os.full)
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.agentStatus",
        defaultMessage: "Agent Status"
      })),
      description: /*#__PURE__*/_react.default.createElement(_endpoint_agent_status.EndpointAgentStatus, {
        pendingActions: getHostPendingActions(hostInfo.metadata.agent.id),
        endpointHostInfo: hostInfo
      })
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.lastSeen",
        defaultMessage: "Last Seen"
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        value: hostInfo.last_checkin || hostInfo.metadata['@timestamp'],
        fieldName: ""
      }))
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.policy",
        defaultMessage: "Policy"
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        className: 'eui-textBreakWord'
      }, /*#__PURE__*/_react.default.createElement(_endpoint_policy_link.EndpointPolicyLink, {
        policyId: hostInfo.metadata.Endpoint.policy.applied.id,
        "data-test-subj": "policyDetailsValue",
        className: 'policyLineText',
        missingPolicies: missingPolicies
      }, hostInfo.metadata.Endpoint.policy.applied.name), hostInfo.metadata.Endpoint.policy.applied.endpoint_policy_version && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        className: 'eui-displayInlineBlock eui-textNoWrap policyLineText',
        "data-test-subj": "policyDetailsRevNo"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.policy.revisionNumber",
        defaultMessage: "rev. {revNumber}",
        values: {
          revNumber: hostInfo.metadata.Endpoint.policy.applied.endpoint_policy_version
        }
      })), (0, _utils.isPolicyOutOfDate)(hostInfo.metadata.Endpoint.policy.applied, policyInfo) && /*#__PURE__*/_react.default.createElement(_out_of_date.OutOfDate, null))
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.policyStatus",
        defaultMessage: "Policy Status"
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        "data-test-subj": `policyStatusValue-${policyStatus}`,
        color: _host_constants.POLICY_STATUS_TO_BADGE_COLOR[policyStatus] || 'default'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: policyStatusClickHandler,
        "data-test-subj": "policyStatusValue"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.policyStatusValue",
        defaultMessage: "{policyStatus, select, success {Success} warning {Warning} failure {Failed} other {Unknown}}",
        values: {
          policyStatus
        }
      }))))
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.endpointVersion",
        defaultMessage: "Endpoint Version"
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, hostInfo.metadata.agent.version)
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.ipAddress",
        defaultMessage: "IP Address"
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "s"
      }, hostInfo.metadata.host.ip.map((ip, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, ip))))
    }];
  }, [hostInfo, getHostPendingActions, missingPolicies, policyInfo, policyStatus, policyStatusClickHandler]);
  return /*#__PURE__*/_react.default.createElement(EndpointDetailsContentStyled, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    columnWidths: [1, 3],
    compressed: true,
    rowGutterSize: "m",
    type: "column",
    listItems: detailsResults,
    "data-test-subj": "endpointDetailsList"
  }));
});
EndpointDetailsContent.displayName = 'EndpointDetailsContent';