"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialEndpointPageState = void 0;
var _constants = require("../../../../../common/endpoint/constants");
var _constants2 = require("../../../common/constants");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialEndpointPageState = () => {
  return {
    hosts: [],
    pageSize: 10,
    pageIndex: 0,
    total: 0,
    sortDirection: _constants.ENDPOINT_DEFAULT_SORT_DIRECTION,
    sortField: _constants.ENDPOINT_DEFAULT_SORT_FIELD,
    loading: false,
    error: undefined,
    location: undefined,
    policyItems: [],
    selectedPolicyId: undefined,
    policyItemsLoading: false,
    endpointPackageInfo: (0, _state.createUninitialisedResourceState)(),
    nonExistingPolicies: {},
    agentPolicies: {},
    endpointsExist: true,
    patterns: [],
    patternsError: undefined,
    isAutoRefreshEnabled: true,
    autoRefreshInterval: _constants2.DEFAULT_POLL_INTERVAL,
    agentsWithEndpointsTotal: 0,
    agentsWithEndpointsTotalError: undefined,
    endpointsTotal: 0,
    endpointsTotalError: undefined,
    isolationRequestState: (0, _state.createUninitialisedResourceState)(),
    endpointPendingActions: (0, _state.createLoadedResourceState)(new Map()),
    metadataTransformStats: (0, _state.createUninitialisedResourceState)(),
    isInitialized: false
  };
};
exports.initialEndpointPageState = initialEndpointPageState;