"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithShowResponder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../common/translations");
var _use_license = require("../../common/hooks/use_license");
var _constants = require("../../../common/endpoint/service/response_actions/constants");
var _is_response_action_supported = require("../../../common/endpoint/service/response_actions/is_response_action_supported");
var _header_sentinel_one_info = require("../components/endpoint_responder/components/header_info/sentinel_one/header_sentinel_one_info");
var _user_privileges = require("../../common/components/user_privileges");
var _endpoint_responder = require("../components/endpoint_responder");
var _console = require("../components/console");
var _missing_encryption_key_callout = require("../components/missing_encryption_key_callout");
var _translations2 = require("./translations");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWithShowResponder = () => {
  const consoleManager = (0, _console.useConsoleManager)();
  const endpointPrivileges = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isEnterpriseLicense = (0, _use_license.useLicense)().isEnterprise();
  const isSentinelOneV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsSentinelOneV1Enabled');
  return (0, _react.useCallback)(props => {
    const {
      agentId,
      agentType,
      capabilities,
      hostName
    } = props;
    // If no authz, just exit and log something to the console
    if (agentType === 'endpoint' && !endpointPrivileges.canAccessResponseConsole) {
      window.console.error(new Error(`Access denied to ${agentType} response actions console`));
      return;
    }
    if (agentType !== 'endpoint' && !isEnterpriseLicense) {
      window.console.error(new Error(`Access denied to ${agentType} response actions console`));
      return;
    }
    const endpointRunningConsole = consoleManager.getOne(agentId);
    if (endpointRunningConsole) {
      endpointRunningConsole.show();
    } else {
      const consoleProps = {
        commands: (0, _endpoint_responder.getEndpointConsoleCommands)({
          agentType,
          endpointAgentId: agentId,
          endpointCapabilities: capabilities,
          endpointPrivileges
        }).map(command => {
          if (command.name !== 'status') {
            return {
              ...command,
              helpHidden: !(0, _is_response_action_supported.isResponseActionSupported)(agentType, _constants.RESPONSE_CONSOLE_COMMAND_TO_API_COMMAND_MAP[command.name], 'manual', endpointPrivileges)
            };
          } else if (agentType !== 'endpoint') {
            // do not show 'status' for non-endpoint agents
            return {
              ...command,
              helpHidden: true,
              validate: () => {
                return (0, _translations.UPGRADE_AGENT_FOR_RESPONDER)(agentType, command.name);
              }
            };
          }
          return command;
        }),
        'data-test-subj': `${agentType}ResponseActionsConsole`,
        storagePrefix: 'xpack.securitySolution.Responder',
        TitleComponent: () => {
          if (agentType === 'endpoint') {
            return /*#__PURE__*/_react.default.createElement(_endpoint_responder.HeaderEndpointInfo, {
              endpointId: agentId
            });
          }
          if (agentType === 'sentinel_one') {
            return /*#__PURE__*/_react.default.createElement(_header_sentinel_one_info.HeaderSentinelOneInfo, {
              agentId: agentId,
              hostName: hostName,
              platform: props.platform
            });
          }
          return null;
        }
      };
      consoleManager.register({
        id: agentId,
        meta: {
          agentId,
          hostName
        },
        consoleProps,
        PageTitleComponent: () => {
          if (isSentinelOneV1Enabled && agentType === 'sentinel_one') {
            return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _translations2.RESPONDER_PAGE_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
              label: _translations.TECHNICAL_PREVIEW,
              tooltipContent: _translations.TECHNICAL_PREVIEW_TOOLTIP
            })));
          }
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.RESPONDER_PAGE_TITLE);
        },
        ActionComponents: endpointPrivileges.canReadActionsLogManagement ? [_endpoint_responder.ActionLogButton] : undefined,
        PageBodyComponent: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_endpoint_responder.OfflineCallout, {
          endpointId: props.agentId,
          agentType: agentType,
          hostName: hostName
        }), /*#__PURE__*/_react.default.createElement(_missing_encryption_key_callout.MissingEncryptionKeyCallout, null))
      }).show();
    }
  }, [endpointPrivileges, isEnterpriseLicense, isSentinelOneV1Enabled, consoleManager]);
};
exports.useWithShowResponder = useWithShowResponder;