"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _translations = require("../translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsLogFilterPopover = exports.ActionsLogFilterPopover = /*#__PURE__*/(0, _react.memo)(({
  children,
  closePopover,
  filterName,
  hasActiveFilters,
  isPopoverOpen,
  numActiveFilters,
  numFilters,
  onButtonClick,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isSentinelOneV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsSentinelOneV1Enabled');
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": getTestId(`${filterName}-filter-popoverButton`),
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: numFilters,
    hasActiveFilters: hasActiveFilters,
    numActiveFilters: numActiveFilters
  }, filterName === 'types' ? isSentinelOneV1Enabled ? _translations.FILTER_NAMES.types(2) : _translations.FILTER_NAMES.types(1) : _translations.FILTER_NAMES[filterName]), [filterName, getTestId, hasActiveFilters, isPopoverOpen, isSentinelOneV1Enabled, numActiveFilters, numFilters, onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, children);
});
ActionsLogFilterPopover.displayName = 'ActionsLogFilterPopover';