"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommandAboutInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNSUPPORTED_COMMAND_INFO = _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.suspendProcess.unsupportedCommandInfo', {
  defaultMessage: 'This version of the Endpoint does not support this command. Upgrade your Agent in Fleet to use the latest response actions.'
});
const DisabledTooltip = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: UNSUPPORTED_COMMAND_INFO,
    type: "warning",
    color: "danger"
  });
});
DisabledTooltip.displayName = 'DisabledTooltip';
const getCommandAboutInfo = ({
  aboutInfo,
  isSupported
}) => {
  return isSupported ? aboutInfo : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, aboutInfo, " ", /*#__PURE__*/_react.default.createElement(DisabledTooltip, null));
};
exports.getCommandAboutInfo = getCommandAboutInfo;