"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionFailureMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _endpoint_action_response_codes = require("../endpoint_responder/lib/endpoint_action_response_codes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointActionFailureMessage = exports.EndpointActionFailureMessage = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj
}) => {
  return (0, _react.useMemo)(() => {
    if (!action.isCompleted || action.wasSuccessful) {
      return null;
    }
    const errors = [];

    // Determine if each endpoint returned a response code and if so,
    // see if we have a localized message for it
    if (action.outputs) {
      for (const agent of action.agents) {
        const endpointAgentOutput = action.outputs[agent];
        if (endpointAgentOutput && endpointAgentOutput.type === 'json' && endpointAgentOutput.content.code && _endpoint_action_response_codes.endpointActionResponseCodes[endpointAgentOutput.content.code]) {
          errors.push(_endpoint_action_response_codes.endpointActionResponseCodes[endpointAgentOutput.content.code]);
        }
      }
    }
    if (!errors.length) {
      if (action.errors) {
        errors.push(...action.errors);
      } else {
        errors.push(_i18n.i18n.translate('xpack.securitySolution.endpointActionFailureMessage.unknownFailure', {
          defaultMessage: 'Action failed'
        }));
      }
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": dataTestSubj
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointResponseActions.actionError.errorMessage",
      defaultMessage: "The following { errorCount, plural, =1 {error was} other {errors were}} encountered:",
      values: {
        errorCount: errors.length
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("div", null, errors.join(' | ')));
  }, [action.agents, action.errors, action.isCompleted, action.outputs, action.wasSuccessful, dataTestSubj]);
});
EndpointActionFailureMessage.displayName = 'EndpointActionFailureMessage';