"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactEntryCollapsibleCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _card_container_panel = require("./components/card_container_panel");
var _use_normalized_artifact = require("./hooks/use_normalized_artifact");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _card_section_panel = require("./components/card_section_panel");
var _criteria_conditions = require("./components/criteria_conditions");
var _card_compressed_header = require("./components/card_compressed_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ArtifactEntryCollapsibleCard = exports.ArtifactEntryCollapsibleCard = /*#__PURE__*/(0, _react.memo)(({
  item,
  onExpandCollapse,
  policies,
  actions,
  expanded = false,
  'data-test-subj': dataTestSubj,
  ...commonProps
}) => {
  const artifact = (0, _use_normalized_artifact.useNormalizedArtifact)(item);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_card_container_panel.CardContainerPanel, (0, _extends2.default)({}, commonProps, {
    "data-test-subj": dataTestSubj
  }), /*#__PURE__*/_react.default.createElement(_card_section_panel.CardSectionPanel, {
    className: "artifact-entry-collapsible-card"
  }, /*#__PURE__*/_react.default.createElement(_card_compressed_header.CardCompressedHeader, {
    artifact: artifact,
    actions: actions,
    policies: policies,
    expanded: expanded,
    onExpandCollapse: onExpandCollapse,
    "data-test-subj": getTestId('header')
  })), expanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_card_section_panel.CardSectionPanel, null, /*#__PURE__*/_react.default.createElement(_criteria_conditions.CriteriaConditions, {
    os: artifact.os,
    entries: artifact.entries,
    "data-test-subj": getTestId('criteriaConditions')
  }))));
});
ArtifactEntryCollapsibleCard.displayName = 'ArtifactEntryCollapsibleCard';