"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MachineLearning = void 0;
var _react = _interopRequireDefault(require("react"));
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _eui = require("@elastic/eui");
var _nav_links = require("../common/links/nav_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MachineLearning = () => {
  const link = (0, _nav_links.useRootNavLink)(_securitySolutionNavigation.SecurityPageName.mlLanding);
  const {
    links = [],
    categories = [],
    title
  } = link !== null && link !== void 0 ? link : {};
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    restrictWidth: false,
    contentBorder: false,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: title
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksIconsCategories, {
    links: links,
    categories: categories
  })));
};
exports.MachineLearning = MachineLearning;