"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineFlyout = exports.SecuritySolutionFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _panel_keys = require("./document_details/shared/constants/panel_keys");
var _isolate_host = require("./document_details/isolate_host");
var _context = require("./document_details/isolate_host/context");
var _right = require("./document_details/right");
var _context2 = require("./document_details/right/context");
var _left = require("./document_details/left");
var _context3 = require("./document_details/left/context");
var _preview = require("./document_details/preview");
var _context4 = require("./document_details/preview/context");
var _user_right = require("./entity_details/user_right");
var _user_details_left = require("./entity_details/user_details_left");
var _host_right = require("./entity_details/host_right");
var _host_details_left = require("./entity_details/host_details_left");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * List of all panels that will be used within the document details expandable flyout.
 * This needs to be passed to the expandable flyout registeredPanels property.
 */
const expandableFlyoutDocumentsPanels = [{
  key: _panel_keys.DocumentDetailsRightPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context2.RightPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_right.RightPanel, {
    path: props.path
  }))
}, {
  key: _panel_keys.DocumentDetailsLeftPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context3.LeftPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_left.LeftPanel, {
    path: props.path
  }))
}, {
  key: _panel_keys.DocumentDetailsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.PreviewPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_preview.PreviewPanel, {
    path: props.path
  }))
}, {
  key: _panel_keys.DocumentDetailsIsolateHostPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context.IsolateHostPanelProvider, props.params, /*#__PURE__*/_react.default.createElement(_isolate_host.IsolateHostPanel, {
    path: props.path
  }))
}, {
  key: _user_right.UserPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_right.UserPanel, props.params)
}, {
  key: _user_details_left.UserDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_details_left.UserDetailsPanel, (0, _extends2.default)({}, props.params, {
    path: props.path
  }))
}, {
  key: _host_right.HostPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_right.HostPanel, props.params)
}, {
  key: _host_details_left.HostDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_details_left.HostDetailsPanel, props.params)
}];

/**
 * Flyout used for the Security Solution application
 * We keep the default EUI 1000 z-index to ensure it is always rendered behind Timeline (which has a z-index of 1001)
 */
const SecuritySolutionFlyout = exports.SecuritySolutionFlyout = /*#__PURE__*/(0, _react.memo)(() => /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyout, {
  registeredPanels: expandableFlyoutDocumentsPanels,
  paddingSize: "none"
}));
SecuritySolutionFlyout.displayName = 'SecuritySolutionFlyout';

/**
 * Flyout used in Timeline
 * We set the z-index to 1002 to ensure it is always rendered above Timeline (which has a z-index of 1001)
 */
const TimelineFlyout = exports.TimelineFlyout = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyout, {
    registeredPanels: expandableFlyoutDocumentsPanels,
    paddingSize: "none",
    customStyles: {
      'z-index': euiTheme.levels.flyout + 2
    }
  });
});
TimelineFlyout.displayName = 'TimelineFlyout';