"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanelContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _asset_criticality_selector = require("../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _observed_details = require("../../../explore/users/containers/users/observed_details");
var _risk_summary = require("../../../entity_analytics/components/risk_summary_flyout/risk_summary");
var _managed_user = require("../../../timelines/components/side_panel/new_user_detail/managed_user");
var _ = require(".");
var _flyout_body = require("../../shared/components/flyout_body");
var _observed_entity = require("../shared/components/observed_entity");
var _use_observed_user_items = require("./hooks/use_observed_user_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserPanelContent = ({
  userName,
  observedUser,
  managedUser,
  riskScoreState,
  contextID,
  scopeId,
  isDraggable,
  openDetailsPanel
}) => {
  var _riskScoreState$data;
  const observedFields = (0, _use_observed_user_items.useObservedUserItems)(observedUser);
  const isManagedUserEnable = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newUserDetailsFlyoutManagedUser');
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, riskScoreState.isModuleEnabled && ((_riskScoreState$data = riskScoreState.data) === null || _riskScoreState$data === void 0 ? void 0 : _riskScoreState$data.length) !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_risk_summary.RiskSummary, {
    riskScoreData: riskScoreState,
    queryId: _.USER_PANEL_RISK_SCORE_QUERY_ID,
    openDetailsPanel: openDetailsPanel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null)), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityAccordion, {
    entity: {
      name: userName,
      type: 'user'
    }
  }), /*#__PURE__*/_react.default.createElement(_observed_entity.ObservedEntity, {
    observedData: observedUser,
    contextID: contextID,
    scopeId: scopeId,
    isDraggable: isDraggable,
    observedFields: observedFields,
    queryId: _observed_details.OBSERVED_USER_QUERY_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), isManagedUserEnable && /*#__PURE__*/_react.default.createElement(_managed_user.ManagedUser, {
    managedUser: managedUser,
    contextID: contextID,
    isDraggable: isDraggable,
    openDetailsPanel: openDetailsPanel
  }));
};
exports.UserPanelContent = UserPanelContent;