"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedHost = void 0;
var _react = require("react");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../../../common/store");
var _details = require("../../../../explore/hosts/containers/hosts/details");
var _use_first_last_seen = require("../../../../common/containers/use_first_last_seen");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _search_strategy = require("../../../../../common/search_strategy");
var _ = require("..");
var _manage_query = require("../../../../common/components/page/manage_query");
var _helpers = require("../../../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObservedHost = (hostName, scopeId) => {
  const timelineTime = (0, _use_selector.useDeepEqualSelector)(state => _store.inputsSelectors.timelineTimeRangeSelector(state));
  const globalTime = (0, _use_global_time.useGlobalTime)();
  const isActiveTimelines = (0, _helpers.isActiveTimeline)(scopeId);
  const {
    to,
    from
  } = isActiveTimelines ? timelineTime : globalTime;
  const {
    isInitializing,
    setQuery,
    deleteQuery
  } = globalTime;
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)((0, _helpers.getSourcererScopeId)(scopeId));
  const [isLoading, {
    hostDetails,
    inspect: inspectObservedHost
  }, refetch] = (0, _details.useHostDetails)({
    endDate: to,
    hostName,
    indexNames: selectedPatterns,
    id: _.HOST_PANEL_RISK_SCORE_QUERY_ID,
    skip: isInitializing,
    startDate: from
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectObservedHost,
    loading: isLoading,
    queryId: _.HOST_PANEL_OBSERVED_HOST_QUERY_ID,
    refetch,
    setQuery
  });
  const [loadingFirstSeen, {
    firstSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'host.name',
    value: hostName,
    defaultIndex: selectedPatterns,
    order: _search_strategy.Direction.asc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  const [loadingLastSeen, {
    lastSeen
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field: 'host.name',
    value: hostName,
    defaultIndex: selectedPatterns,
    order: _search_strategy.Direction.desc,
    filterQuery: _search_strategy.NOT_EVENT_KIND_ASSET_FILTER
  });
  return (0, _react.useMemo)(() => ({
    details: hostDetails,
    isLoading: isLoading || loadingLastSeen || loadingFirstSeen,
    firstSeen: {
      date: firstSeen,
      isLoading: loadingFirstSeen
    },
    lastSeen: {
      date: lastSeen,
      isLoading: loadingLastSeen
    }
  }), [firstSeen, hostDetails, isLoading, lastSeen, loadingFirstSeen, loadingLastSeen]);
};
exports.useObservedHost = useObservedHost;