"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetailsPanelKey = exports.HostDetailsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _entity_details_flyout = require("../../../entity_analytics/components/entity_details_flyout");
var _left_panel_content = require("../shared/components/left_panel/left_panel_content");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _risk_engine = require("../../../../common/entity_analytics/risk_engine");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostDetailsPanelKey = exports.HostDetailsPanelKey = 'host_details';
const HostDetailsPanel = ({
  name,
  isRiskScoreExist
}) => {
  // Temporary implementation while Host details left panel don't have Asset tabs
  const [tabs, selectedTabId, setSelectedTabId] = (0, _react.useMemo)(() => {
    const isRiskScoreTabAvailable = isRiskScoreExist && name;
    return [isRiskScoreTabAvailable ? [(0, _entity_details_flyout.getRiskInputTab)({
      entityName: name,
      entityType: _risk_engine.RiskScoreEntity.host
    })] : [], _left_panel_header.EntityDetailsLeftPanelTab.RISK_INPUTS, () => {}];
  }, [name, isRiskScoreExist]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_left_panel_header.LeftPanelHeader, {
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    tabs: tabs
  }), /*#__PURE__*/_react.default.createElement(_left_panel_content.LeftPanelContent, {
    selectedTabId: selectedTabId,
    tabs: tabs
  }));
};
exports.HostDetailsPanel = HostDetailsPanel;
HostDetailsPanel.displayName = 'HostDetailsPanel';