"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tourConfig = exports.getRightSectionTourSteps = exports.getLeftSectionTourSteps = exports.FLYOUT_TOUR_CONFIG_ANCHORS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _test_ids = require("../../../shared/components/test_ids");
var _test_ids2 = require("../../right/test_ids");
var _test_ids3 = require("../../right/components/test_ids");
var _test_ids4 = require("../../left/tabs/test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLYOUT_TOUR_CONFIG_ANCHORS = exports.FLYOUT_TOUR_CONFIG_ANCHORS = {
  OVERVIEW_TAB: _test_ids2.OVERVIEW_TAB_LABEL_TEST_ID,
  RULE_PREVIEW: _test_ids3.RULE_SUMMARY_BUTTON_TEST_ID,
  NAVIGATION_BUTTON: _test_ids.HEADER_NAVIGATION_BUTTON_TEST_ID,
  ENTITIES: _test_ids4.INSIGHTS_TAB_ENTITIES_BUTTON_LABEL_TEST_ID,
  PREVALENCE: _test_ids4.INSIGHTS_TAB_PREVALENCE_BUTTON_LABEL_TEST_ID
};
const tourConfig = exports.tourConfig = {
  currentTourStep: 1,
  isTourActive: true
};
const getRightSectionTourSteps = () => {
  const rightSectionTourSteps = [{
    title: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.overview.title', {
      defaultMessage: 'More ways to understand your alerts'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.tour.overview.description",
      defaultMessage: "Explore new insights in the {entities} and {prevalence} sections.",
      values: {
        entities: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.overview.entities.text', {
          defaultMessage: 'Entities'
        })),
        prevalence: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.overview.prevalence.text', {
          defaultMessage: 'Prevalence'
        }))
      }
    })),
    stepNumber: 1,
    anchor: FLYOUT_TOUR_CONFIG_ANCHORS.OVERVIEW_TAB,
    anchorPosition: 'downCenter'
  }, {
    title: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.preview.title', {
      defaultMessage: 'A quick way to access rule details'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.tour.rulePreview.description",
      defaultMessage: "Click {rulePreview} to learn more about the rule that generated the alert.",
      values: {
        rulePreview: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.rulePreview.text', {
          defaultMessage: 'Show rule summary'
        }))
      }
    })),
    stepNumber: 2,
    anchor: FLYOUT_TOUR_CONFIG_ANCHORS.RULE_PREVIEW,
    anchorPosition: 'rightUp'
  }, {
    title: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.expandDetails.title', {
      defaultMessage: 'An expanded view of important alert details'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.tour.expandDetails.description",
      defaultMessage: "Click the linked text to open and close the flyout's left panel. The left panel is a detailed view of sections in the right panel."
    })),
    stepNumber: 3,
    anchor: FLYOUT_TOUR_CONFIG_ANCHORS.NAVIGATION_BUTTON,
    anchorPosition: 'downCenter'
  }];
  return rightSectionTourSteps;
};
exports.getRightSectionTourSteps = getRightSectionTourSteps;
const getLeftSectionTourSteps = () => {
  return [{
    title: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.entities.title', {
      defaultMessage: 'New host and user insights are available'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.tour.entities.description",
      defaultMessage: "Check out the expanded {entities} view to learn more about hosts and users that are related to the alert.",
      values: {
        entities: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.entities.text', {
          defaultMessage: 'Entities'
        }))
      }
    })),
    stepNumber: 4,
    anchor: FLYOUT_TOUR_CONFIG_ANCHORS.ENTITIES,
    anchorPosition: 'rightUp'
  }, {
    title: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.prevalence.title', {
      defaultMessage: 'New host and user insights are available'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.tour.prevalence.description",
      defaultMessage: "Check out the expanded {prevalence} view to learn how the alert is related to other alerts, events, and entities.",
      values: {
        prevalence: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.prevalence.text', {
          defaultMessage: 'Prevalence'
        }))
      }
    })),
    stepNumber: 5,
    anchor: FLYOUT_TOUR_CONFIG_ANCHORS.PREVALENCE,
    anchorPosition: 'rightUp'
  }];
};
exports.getLeftSectionTourSteps = getLeftSectionTourSteps;