"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighlightedFields = void 0;
var _fp = require("lodash/fp");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sentinelone_alert_check = require("../../../../common/utils/sentinelone_alert_check");
var _endpoint_alert_check = require("../../../../common/utils/endpoint_alert_check");
var _get_alert_summary_rows = require("../../../../common/components/event_details/get_alert_summary_rows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the highlighted fields to display in the right panel under the Investigation section.
 */
const useHighlightedFields = ({
  dataFormattedForFieldBrowser,
  investigationFields
}) => {
  var _eventCodeField$origi, _eventRuleTypeField$o;
  const eventCategories = (0, _get_alert_summary_rows.getEventCategoriesFromData)(dataFormattedForFieldBrowser);
  const eventCodeField = (0, _fp.find)({
    category: 'event',
    field: 'event.code'
  }, dataFormattedForFieldBrowser);
  const eventCode = Array.isArray(eventCodeField === null || eventCodeField === void 0 ? void 0 : eventCodeField.originalValue) ? eventCodeField === null || eventCodeField === void 0 ? void 0 : (_eventCodeField$origi = eventCodeField.originalValue) === null || _eventCodeField$origi === void 0 ? void 0 : _eventCodeField$origi[0] : eventCodeField === null || eventCodeField === void 0 ? void 0 : eventCodeField.originalValue;
  const eventRuleTypeField = (0, _fp.find)({
    category: 'kibana',
    field: _ruleDataUtils.ALERT_RULE_TYPE
  }, dataFormattedForFieldBrowser);
  const eventRuleType = Array.isArray(eventRuleTypeField === null || eventRuleTypeField === void 0 ? void 0 : eventRuleTypeField.originalValue) ? eventRuleTypeField === null || eventRuleTypeField === void 0 ? void 0 : (_eventRuleTypeField$o = eventRuleTypeField.originalValue) === null || _eventRuleTypeField$o === void 0 ? void 0 : _eventRuleTypeField$o[0] : eventRuleTypeField === null || eventRuleTypeField === void 0 ? void 0 : eventRuleTypeField.originalValue;
  const tableFields = (0, _get_alert_summary_rows.getEventFieldsToDisplay)({
    eventCategories,
    eventCode,
    eventRuleType,
    highlightedFieldsOverride: investigationFields !== null && investigationFields !== void 0 ? investigationFields : []
  });
  return tableFields.reduce((acc, field) => {
    var _find$values, _find;
    const item = dataFormattedForFieldBrowser.find(data => data.field === field.id || field.legacyId && data.field === field.legacyId);
    if (!item) {
      return acc;
    }

    // if there aren't any values we can skip this highlighted field
    const fieldValues = item.values;
    if (!fieldValues || (0, _fp.isEmpty)(fieldValues)) {
      return acc;
    }

    // if we found the data by its legacy id we swap the ids to display the correct one
    if (item.field === field.legacyId) {
      field.id = field.legacyId;
    }

    // if the field is agent.id and the event is not an endpoint event we skip it
    if (field.id === 'agent.id' && !(0, _endpoint_alert_check.isAlertFromEndpointEvent)({
      data: dataFormattedForFieldBrowser
    })) {
      return acc;
    }

    // if the field is observer.serial_number and the event is not a sentinel one event we skip it
    if (field.id === _sentinelone_alert_check.SENTINEL_ONE_AGENT_ID_FIELD && !(0, _sentinelone_alert_check.isAlertFromSentinelOneEvent)({
      data: dataFormattedForFieldBrowser
    })) {
      return acc;
    }
    return {
      ...acc,
      [field.id]: {
        ...(field.overrideField && {
          overrideField: {
            field: field.overrideField,
            values: (_find$values = (_find = (0, _fp.find)({
              field: field.overrideField
            }, dataFormattedForFieldBrowser)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : []
          }
        }),
        values: fieldValues
      }
    };
  }, {});
};
exports.useHighlightedFields = useHighlightedFields;